package cn.com.duiba.geo.api.aop;

import cn.com.duiba.geo.api.GeoProperties;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GeoRemoteInterceptor extends HandlerInterceptorAdapter {

    @Resource
    private GeoRemoteAspect geoRemoteAspect;
    @Resource
    private GeoProperties geoProperties;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if(!geoProperties.getSessionCache()){
            return true;
        }
        geoRemoteAspect.createGeoSession(request.getRequestURI());
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        geoRemoteAspect.clear();
    }
}
