package cn.com.duiba.geo.api.aop;

import cn.com.duiba.geo.api.dto.IpAreaDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

@Slf4j
@EqualsAndHashCode(callSuper = true)
@Data
class GeoSession extends HashMap<String, IpAreaDto> {

    private AtomicInteger count = new AtomicInteger();

    private static final long serialVersionUID = -7872672819018797755L;

    private String uri;

    IpAreaDto getIpAreaDto(String ip){
        if(count.incrementAndGet()>20){
            log.warn("接口:"+uri+"对GEO服务存在循环调用");//允许调用多次，但是相同的IP不能调用多次
        }
        return this.get(ip);
    }

}
