package cn.com.duiba.geo.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.geo.api.dto.AdministrativeDivisionDto;
import cn.com.duiba.geo.api.dto.DivisionDto;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 行政区域查询接口
 */
@AdvancedFeignClient
public interface RemoteAdministrativeDivisionService {

    /**
     * 根据中国行政区号查行政区域名称（支持5级）
     * //行政级别 1 省，州 2 市 3 县，区  4 乡镇，街道
     *
     * @param adcode 行政区域编码 支持 2位 4位 6位 9位
     * @return 返回adcode对应的 行政区域降序编排
     * <p>
     * EX: 33,3300,330000 -> [浙江]
     * EX: 330100 -> [浙江,杭州]
     * EX: 330106 -> [浙江,杭州,西湖]
     * EX: 330106007 -> [浙江,杭州,西湖,古荡]
     * <p>
     * 如 adcode 存在错误，查询结果会遍历到错误区域前一级
     * <p>
     * EX: 330106999 -> [浙江,杭州,西湖]  999没有对应的区域
     */
    @RequestMapping(method = RequestMethod.GET)
    List<AdministrativeDivisionDto> findAdministrativeDivisionByCode(String adcode);

    /**
     * 获取省级行政区域列表(可用于地址联动加载)
     *
     * @return 省级区域，包括 直辖市，港澳台
     */
    @RequestMapping(method = RequestMethod.GET)
    List<AdministrativeDivisionDto> findRegionDivision();

    /**
     * 获取省级和城市行政区划，城市包括省直辖县
     */
    @RequestMapping(method = RequestMethod.GET)
    List<DivisionDto> findRegionAndCityDivision();

    /**
     * 根据父级行政编号查询下一级行政区域列表(可用于地址联动加载)
     *
     * @param adcode 父级行政区域编码 支持 2位 4位 6位 9位
     * @return 子级行政单位列表
     */
    @RequestMapping(method = RequestMethod.GET)
    List<AdministrativeDivisionDto> findAdministrativeDivisionByParentAdCode(String adcode);

    /**
     * 检索对应的行政区划的区划编号
     * @param adNames 按 省 市 区 镇 的顺序传入，最多4级，adNames的Size可以随意 EX：省 市
     * @return 行政区划的编码 省 市 区 为6位 乡镇为 9位
     * 传入的行政链路允许出现断层，GEO会做磁力关联
     * EX:浙江，西湖
     */
    @RequestMapping(method = RequestMethod.GET)
    String findAdcode(List<String> adNames);


}
