package cn.com.duiba.geo.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.geo.api.dto.CoordinateSystem;
import cn.com.duiba.geo.api.dto.GeoInfoDto;
import cn.com.duiba.geo.api.dto.Point;

@AdvancedFeignClient
public interface RemoteGeoService {

    /**
     * 根据geoHash得到地理信息
     * @param geoHash 地理编码
     * @param coordinateSystem 参考坐标系
     * @return 行政区信息
     */
    GeoInfoDto findGeoInfoByGeoHash(String geoHash, CoordinateSystem coordinateSystem);

    /**
     * 根据经纬坐标点查询地理信息
     * @param point 经纬度坐标点
     * @param coordinateSystem 参考坐标系
     * @return 行政区信息
     */
    GeoInfoDto findGeoInfoByPoint(Point point, CoordinateSystem coordinateSystem);

}
