/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.api.aop;

import cn.com.duiba.geo.api.aop.GeoSession;
import cn.com.duiba.geo.api.dto.IpAreaDto;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Objects;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.context.ApplicationContext;

@Aspect
public class GeoRemoteAspect {
    private TransmittableThreadLocal<GeoSession> geoSessionThreadLocal = new TransmittableThreadLocal();
    @Resource
    private ApplicationContext applicationContext;

    void createGeoSession(String uri) {
        GeoSession session = new GeoSession();
        session.setUri(uri);
        this.geoSessionThreadLocal.set((Object)session);
    }

    void clear() {
        this.geoSessionThreadLocal.remove();
    }

    @Around(value="execution(* cn.com.duiba.geo.api.remoteservice.RemoteIpAreaService.*(..)) && args(ip,..)")
    public IpAreaDto findIpArea(ProceedingJoinPoint joinPoint, String ip) throws Throwable {
        GeoSession session = (GeoSession)this.geoSessionThreadLocal.get();
        if (Objects.isNull(session)) {
            return (IpAreaDto)joinPoint.proceed();
        }
        if (session.containsKey(ip)) {
            return session.getIpAreaDto(ip);
        }
        IpAreaDto ipAreaDto = (IpAreaDto)joinPoint.proceed();
        session.put(ip, ipAreaDto);
        this.applicationContext.publishEvent((Object)ipAreaDto);
        return ipAreaDto;
    }
}

