package cn.com.duiba.geo.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author liuyao
 */
@Data
public class IpGeoInfoDto implements Serializable {

    private String ip;
    /**
     * 运营商
     */
    private String isp;
    /**
     * 是否定位在国外
     */
    private Boolean international;
    /**
     * 定位精度:0:国家,1:地区,2:城市,3:区县,4:乡镇
     */
    private Integer adLevel = 0;

    /**
     * 当为国内时才会有值 6位，定位到乡镇时，为 9 位
     */
    private String adCode;
    /**
     * 国家，地区，城市，区县，乡镇
     */
    private List<String> acNames;


}
