package cn.com.duiba.geo.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.geo.api.dto.IpAreaDto;
import cn.com.duiba.geo.api.dto.IpGeoInfoDto;
import cn.com.duiba.geo.api.params.IpGeoInfoParams;

import java.util.List;

/**
 * GEO地域信息查询
 * GEO的地址名称都经过简化处理，行政地域名称后均不带行政等级后缀 比如 省 市 县
 * 为了配合GeoRemoteAspect，该接口所有的方法的第一个参数都为ip
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteIpAreaService {

    /**
     * 查询IP归属地
     */
    IpAreaDto findIpInfo(String ip);

    /**
     * 批量查询ip信息
     * @param ips ip
     * @return ip对应的地域信息
     */
    List<IpAreaDto> findAllIpInfoByIpIn(List<String> ips);

    /**
     * 查询IP归属地
     */
    IpGeoInfoDto findIpGeoInfo(IpGeoInfoParams params);


}
