/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.server.common.enums;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum AdArea {
    HUA_DONG(1, "\u534e\u4e1c\u5730\u533a", Sets.newHashSet((Object[])new String[]{"31", "32", "33", "34", "35", "36", "37"})),
    HUA_BEI(2, "\u534e\u5317\u5730\u533a", Sets.newHashSet((Object[])new String[]{"11", "12", "13", "14", "15"})),
    HUA_ZH(3, "\u534e\u4e2d\u5730\u533a", Sets.newHashSet((Object[])new String[]{"41", "42", "43"})),
    HUA_NAN(4, "\u534e\u5357\u5730\u533a", Sets.newHashSet((Object[])new String[]{"44", "45", "46"})),
    DONG_BEI(5, "\u4e1c\u5317\u5730\u533a", Sets.newHashSet((Object[])new String[]{"21", "22", "23"})),
    XI_BEI(6, "\u897f\u5317\u5730\u533a", Sets.newHashSet((Object[])new String[]{"61", "62", "63", "64", "65"})),
    XI_NAN(7, "\u897f\u5357\u5730\u533a", Sets.newHashSet((Object[])new String[]{"50", "51", "52", "53", "54"})),
    GANG_AO_TAI(8, "\u6e2f\u6fb3\u53f0", Sets.newHashSet((Object[])new String[]{"71", "81", "82"})),
    OTHER(99, "\u5176\u4ed6", Sets.newHashSet());

    private Integer code;
    private String rankDesc;
    private Set<String> citySet;

    private AdArea(Integer code, String rankDesc, Set<String> citySet) {
        this.code = code;
        this.rankDesc = rankDesc;
        this.citySet = citySet;
    }

    public static AdArea getAdAreaByCode(String adCode) {
        if (StringUtils.isBlank((CharSequence)adCode)) {
            return OTHER;
        }
        AdArea[] adAreas = AdArea.values();
        for (int i = 0; i < adAreas.length; ++i) {
            Set<String> citySet = adAreas[i].getCitySet();
            if (!citySet.stream().anyMatch(prefix -> adCode.startsWith((String)prefix))) continue;
            return adAreas[i];
        }
        return OTHER;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getRankDesc() {
        return this.rankDesc;
    }

    public Set<String> getCitySet() {
        return this.citySet;
    }
}

