/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.server.common.tire;

import cn.com.duiba.geo.server.common.tire.TireTreeNodePolicy;
import cn.com.duiba.geo.server.common.tire.TireTreeNodeShim;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TireTreeNode {
    private TireTreeNode[] childs;
    private TireTreeNodeShim payload;

    TireTreeNodeShim getPayload() {
        return this.payload;
    }

    final int insert(char[] chars, int level, TireTreeNodePolicy policy, TireTreeNodeShim payload) {
        int index;
        if (chars.length == 0) {
            throw new IllegalArgumentException("\u5b57\u5178\u6811\u89e3\u6790\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.childs == null) {
            this.childs = new TireTreeNode[policy.charSize()];
        }
        if (this.childs[index = policy.charIndex(chars[level])] == null) {
            this.childs[index] = new TireTreeNode();
        }
        TireTreeNode child = this.childs[index];
        if (level == chars.length - 1) {
            child.payload = payload;
            return level + 1;
        }
        return child.insert(chars, level + 1, policy, payload);
    }

    final TireTreeNode find(char[] chars, int level, TireTreeNodePolicy policy) {
        if (chars.length == level) {
            return this;
        }
        if (Objects.isNull(this.childs)) {
            return null;
        }
        int index = policy.charIndex(chars[level]);
        TireTreeNode node = this.childs[index];
        if (Objects.isNull(node)) {
            return null;
        }
        return node.find(chars, level + 1, policy);
    }

    final void findToList(char[] chars, int level, LinkedList<TireTreeNode> nodes, TireTreeNodePolicy policy) {
        if (Objects.nonNull(this.payload)) {
            nodes.add(this);
        }
        if (level >= chars.length) {
            return;
        }
        int childIndex = policy.charIndex(chars[level]);
        if (this.childs == null || Objects.isNull(this.childs[childIndex])) {
            return;
        }
        TireTreeNode node = this.childs[childIndex];
        node.findToList(chars, level + 1, nodes, policy);
    }

    final void findInDeep(List<TireTreeNode> list) {
        if (Objects.isNull(this.childs)) {
            return;
        }
        for (TireTreeNode child : this.childs) {
            if (Objects.isNull(child)) continue;
            if (Objects.nonNull(child.payload)) {
                list.add(child);
                continue;
            }
            child.findInDeep(list);
        }
    }

    public String toString() {
        return "TireTreeNode{code='" + (String)Optional.ofNullable(this.payload).map(TireTreeNodeShim::getTireTreeKey).orElse(null) + '}';
    }
}

