/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.server.service.ad;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.geo.server.common.enums.AdArea;
import cn.com.duiba.geo.server.common.enums.AdRank;
import cn.com.duiba.geo.server.common.tire.TireTree;
import cn.com.duiba.geo.server.dao.AdministrativeDivisionDao;
import cn.com.duiba.geo.server.domain.entity.AdministrativeDivisionDO;
import cn.com.duiba.geo.server.dto.AdministrativeDivisionDto;
import cn.com.duiba.geo.server.service.ad.AdministrativeDivisionTreeNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Order(value=0x7FFFFFFE)
public class AdministrativeDivisionService {
    private static final Logger log = LoggerFactory.getLogger(AdministrativeDivisionService.class);
    @Resource
    private AdministrativeDivisionDao administrativeDivisionDao;
    private final Ordering<AdministrativeDivisionDO> ordering = Ordering.natural().onResultOf(AdministrativeDivisionDO::getCode);
    private volatile TireTree<AdministrativeDivisionTreeNode> tireTree = new TireTree();
    private volatile Multimap<String, AdministrativeDivisionTreeNode> areaNameMap = HashMultimap.create();

    public AdministrativeDivisionDO findByCode(String code) {
        return this.administrativeDivisionDao.findFirstByCode(code);
    }

    public List<AdministrativeDivisionDO> orderingAdministrativeDivision(List<AdministrativeDivisionDO> ads) {
        return this.ordering.sortedCopy(ads);
    }

    @Transactional
    public void createAdministrativeDivision(AdministrativeDivisionDto params) {
        AdministrativeDivisionDO ad = new AdministrativeDivisionDO();
        ad.setCode(params.getAdCode());
        ad.setName(params.getName());
        ad.setLevel(params.getLevel());
        this.administrativeDivisionDao.save(ad);
    }

    @Transactional
    public void updateAdministrativeDivision(AdministrativeDivisionDto params) throws BizException {
        AdministrativeDivisionDO ad = this.administrativeDivisionDao.findFirstByCode(params.getAdCode());
        if (Objects.isNull(ad)) {
            throw new BizException("\u884c\u653f\u533a\u5212\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ad.setName(params.getName());
        this.administrativeDivisionDao.save(ad);
    }

    @Transactional
    public void deleteAdministrativeDivision(String adCode) throws BizException {
        AdministrativeDivisionDO ad = this.administrativeDivisionDao.findFirstByCode(adCode);
        if (Objects.isNull(ad)) {
            return;
        }
        String code = AdministrativeDivisionTreeNode.analysisCode(adCode);
        int childsCount = this.administrativeDivisionDao.countAllByCodeLikeAndLevelNot(code, ad.getLevel());
        if (childsCount != 0) {
            throw new BizException("\u5b58\u5728\u5b50\u7ea7\u884c\u653f\u533a\u5212,\u5f53\u524d\u533a\u5212\u4e0d\u80fd\u5220\u9664");
        }
        this.administrativeDivisionDao.delete(ad);
    }

    @PostConstruct
    public void initData() {
        TireTree<AdministrativeDivisionTreeNode> newTireTree = new TireTree<AdministrativeDivisionTreeNode>();
        HashMultimap newAreaNameMap = HashMultimap.create();
        List<AdministrativeDivisionDO> list = this.administrativeDivisionDao.findSimpleAll();
        for (AdministrativeDivisionDO item : list) {
            AdministrativeDivisionTreeNode node = new AdministrativeDivisionTreeNode();
            node.setCode(item.getCode());
            node.setName(item.getName());
            node.setLevel(item.getLevel());
            newAreaNameMap.put((Object)item.getName(), (Object)node);
            newAreaNameMap.put((Object)this.simpleName(item.getName()), (Object)node);
            newTireTree.insert(node);
        }
        this.tireTree = newTireTree;
        this.areaNameMap = newAreaNameMap;
        log.info("\u884c\u653f\u533a\u5212\u5b57\u5178\u6811\u6784\u5efa\u5b8c\u6210,\u603b\u6570:" + list.size());
    }

    public List<AdministrativeDivisionDto> findCodeLink(String code) {
        if (!this.isLegal(code).booleanValue()) {
            return Collections.emptyList();
        }
        String key = AdministrativeDivisionTreeNode.analysisCode(code);
        List<AdministrativeDivisionTreeNode> list = this.tireTree.findNodeLink(key);
        return this.trasform(list);
    }

    public List<AdministrativeDivisionDto> findAdministrativeDivisionByParentAdCode(String code) {
        if (!this.isLegal(code).booleanValue()) {
            return Collections.emptyList();
        }
        String key = AdministrativeDivisionTreeNode.analysisCode(code);
        List<AdministrativeDivisionTreeNode> list = this.tireTree.findChildNodes(key, StringUtils.isBlank((CharSequence)code));
        return this.trasform(list);
    }

    private List<AdministrativeDivisionDto> trasform(List<AdministrativeDivisionTreeNode> nodes) {
        ArrayList returnList = Lists.newArrayList();
        for (AdministrativeDivisionTreeNode node : nodes) {
            AdministrativeDivisionDto dto = new AdministrativeDivisionDto();
            dto.setAdCode(node.getCode());
            dto.setName(node.getName());
            dto.setLevel(node.getLevel());
            returnList.add(dto);
        }
        return returnList;
    }

    public String findAdministrativeDivisionCode(List<String> adNames) {
        LinkedHashSet searchSet = Sets.newLinkedHashSet();
        for (String areaName : adNames) {
            if (StringUtils.isBlank((CharSequence)areaName)) continue;
            searchSet.add(areaName);
        }
        List filterList = Lists.reverse(adNames);
        String code = "";
        int expectancyLevel = adNames.size();
        for (String adName : filterList) {
            searchSet.remove(adName);
            Collection collections = this.areaNameMap.get((Object)adName);
            if (collections.isEmpty()) {
                collections = this.areaNameMap.get((Object)this.simpleName(adName));
            }
            List<Object> filterNodeList = Lists.newArrayList();
            for (AdministrativeDivisionTreeNode node : collections) {
                List<AdministrativeDivisionDto> links = this.findCodeLink(node.getCode());
                if (links.isEmpty()) continue;
                Set<String> linkNames = links.stream().map(AdministrativeDivisionDto::getName).collect(Collectors.toSet());
                linkNames.remove(adName);
                if (!this.matchAreaNames(searchSet, linkNames)) continue;
                filterNodeList.add(node);
            }
            if (!(filterNodeList = this.magnetic(expectancyLevel, (List<AdministrativeDivisionTreeNode>)filterNodeList)).isEmpty()) {
                code = ((AdministrativeDivisionTreeNode)filterNodeList.get(0)).getCode();
                break;
            }
            if (expectancyLevel <= 1) continue;
            --expectancyLevel;
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            code = "100000";
        }
        return code;
    }

    public String simpleName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        if (name.length() <= 2) {
            return name;
        }
        if (name.contains("\u81ea\u6cbb")) {
            return name;
        }
        if (StringUtils.endsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"\u7701", "\u5dde", "\u5e02", "\u53bf", "\u9547"})) {
            return name.substring(0, name.length() - 1);
        }
        if (StringUtils.endsWith((CharSequence)name, (CharSequence)"\u8857\u9053")) {
            return name.substring(0, name.length() - 2);
        }
        return name;
    }

    private List<AdministrativeDivisionTreeNode> magnetic(int expectancyLevel, List<AdministrativeDivisionTreeNode> sourceList) {
        ArrayList returnList = Lists.newArrayList();
        int deff = Integer.MAX_VALUE;
        for (AdministrativeDivisionTreeNode node : sourceList) {
            int differential = Math.abs(expectancyLevel - node.getLevel());
            if (differential > deff) continue;
            if (differential < deff) {
                returnList.clear();
                deff = differential;
            }
            returnList.add(node);
        }
        return returnList;
    }

    private boolean matchAreaNames(Set<String> searchSet, Set<String> linkSet) {
        if (searchSet.size() > linkSet.size()) {
            return false;
        }
        int matchCount = 0;
        block0: for (String item : searchSet) {
            for (String sourceName : linkSet) {
                if (!item.startsWith(this.simpleName(sourceName)) && !sourceName.startsWith(this.simpleName(item))) continue;
                ++matchCount;
                continue block0;
            }
        }
        return matchCount == searchSet.size();
    }

    public Boolean isLegal(String adcode) {
        if (StringUtils.equals((CharSequence)"", (CharSequence)adcode)) {
            return true;
        }
        int length = adcode.length();
        if (length != 6 && length != 9 && length != 12) {
            return false;
        }
        try {
            Integer.parseInt(adcode);
        }
        catch (NumberFormatException e) {
            log.debug(adcode + "\u53c2\u6570\u4e0d\u5408\u6cd5");
            return false;
        }
        return true;
    }

    public String updateRankAndArea() {
        List all = this.administrativeDivisionDao.findAll();
        int sum = 0;
        Lists.partition((List)all, (int)2000).forEach(list -> {
            list.forEach(divisionDO -> {
                divisionDO.setRank(AdRank.getAdRankByCityName(divisionDO.getCode()).getCode());
                if (Objects.equals(divisionDO.getLevel(), 1) && !AdRank.TIER_FIRST_CITY.getCitySet().stream().anyMatch(prefix -> divisionDO.getCode().startsWith((String)prefix))) {
                    divisionDO.setRank(null);
                }
                divisionDO.setArea(AdArea.getAdAreaByCode(divisionDO.getCode()).getCode());
            });
            this.administrativeDivisionDao.saveAll((Iterable)list);
            log.warn("saveAll count={}", (Object)(sum + list.size()));
        });
        return "success";
    }
}

