/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.geo.server.service.point;

import ch.hsr.geohash.GeoHash;
import ch.hsr.geohash.WGS84Point;
import cn.com.duiba.geo.server.GeoBizProperties;
import cn.com.duiba.geo.server.common.tire.TireTree;
import cn.com.duiba.geo.server.dao.GeoPointDao;
import cn.com.duiba.geo.server.domain.entity.GeoPointDO;
import cn.com.duiba.geo.server.dto.AdministrativeDivisionDto;
import cn.com.duiba.geo.server.dto.CoordinateSystem;
import cn.com.duiba.geo.server.dto.GeoInfoDto;
import cn.com.duiba.geo.server.dto.Point;
import cn.com.duiba.geo.server.service.ad.AdministrativeDivisionService;
import cn.com.duiba.geo.server.service.point.GeoPointTireTreeNode;
import cn.com.duiba.geo.server.service.point.GeoPointTireTreePolicy;
import cn.com.duiba.geo.server.tool.GpsCoordinateUtils;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GeoPointService {
    private static final Logger log = LoggerFactory.getLogger(GeoPointService.class);
    public static final int GEO_HASH_LENGTH = 8;
    private volatile TireTree<GeoPointTireTreeNode> tireTree = new TireTree(new GeoPointTireTreePolicy());
    @Resource
    private AdministrativeDivisionService administrativeDivisionService;
    @Resource
    private GeoPointDao geoPointDao;
    @Resource
    private GeoBizProperties geoBizProperties;

    public GeoInfoDto findGeoInfoDto(GeoHash geoHash) {
        GeoInfoDto geoInfoDto = new GeoInfoDto();
        String geoHashString = geoHash.toBase32();
        geoInfoDto.setGeoHash(geoHashString);
        WGS84Point point = geoHash.getOriginatingPoint();
        if (GpsCoordinateUtils.isOutOfChina(point.getLatitude(), point.getLongitude(), false)) {
            return geoInfoDto;
        }
        GeoPointTireTreeNode node = this.tireTree.find(geoHashString);
        if (Objects.isNull(node)) {
            node = this.findNearGeoInfoDto(geoHash);
        }
        if (Objects.isNull(node)) {
            return geoInfoDto;
        }
        List<AdministrativeDivisionDto> adList = this.administrativeDivisionService.findCodeLink(node.getAdCode());
        if (adList.isEmpty()) {
            return geoInfoDto;
        }
        AdministrativeDivisionDto administrativeDivision = adList.get(adList.size() - 1);
        geoInfoDto.setAdLevel(administrativeDivision.getLevel());
        geoInfoDto.setAdCode(administrativeDivision.getAdCode());
        geoInfoDto.setAdNames(adList.stream().map(AdministrativeDivisionDto::getName).collect(Collectors.toList()));
        return geoInfoDto;
    }

    private GeoPointTireTreeNode findNearGeoInfoDto(GeoHash geoHash) {
        List<GeoPointTireTreeNode> nodes;
        String parentGeoHash = geoHash.toBase32();
        do {
            parentGeoHash = this.getParentGeoHash(parentGeoHash);
            nodes = this.tireTree.findChildNodes(parentGeoHash, true);
            if (parentGeoHash.length() > 1 || !nodes.isEmpty()) continue;
            return null;
        } while (nodes.isEmpty() && StringUtils.isNotBlank((String)parentGeoHash));
        if (nodes.isEmpty()) {
            return null;
        }
        GeoHash temp = GeoHash.fromGeohashString((String)parentGeoHash);
        for (GeoHash item : temp.getAdjacent()) {
            nodes.addAll(this.tireTree.findChildNodes(item.toBase32(), true));
        }
        HashMap distanceMap = Maps.newHashMap();
        WGS84Point foo = geoHash.getOriginatingPoint();
        for (GeoPointTireTreeNode node : nodes) {
            WGS84Point bar = new WGS84Point(node.getLatitude(), node.getLongitude());
            double distance = this.distanceInMeters(foo, bar);
            distanceMap.put(distance, node);
        }
        double minDistance = (Double)Collections.min(distanceMap.keySet());
        return (GeoPointTireTreeNode)distanceMap.get(minDistance);
    }

    private double distanceInMeters(WGS84Point foo, WGS84Point bar) {
        return Math.pow(foo.getLatitude() - bar.getLatitude(), 2.0) + Math.pow(foo.getLongitude() - bar.getLongitude(), 2.0);
    }

    private String getParentGeoHash(String geoHash) {
        if (StringUtils.isBlank((String)geoHash)) {
            return "";
        }
        return geoHash.substring(0, geoHash.length() - 1);
    }

    @PostConstruct
    public synchronized void initData() {
        if (!this.geoBizProperties.getLoadGeoPoint().booleanValue()) {
            return;
        }
        TireTree<GeoPointTireTreeNode> newTireTree = new TireTree<GeoPointTireTreeNode>(new GeoPointTireTreePolicy());
        try {
            List list = this.geoPointDao.findAll();
            for (GeoPointDO item : list) {
                GeoPointTireTreeNode node = new GeoPointTireTreeNode();
                node.setAdCode(item.getAdCode());
                node.setGeoHash(item.getGeoHash());
                node.setLatitude(item.getLatitude());
                node.setLongitude(item.getLongitude());
                newTireTree.insert(node);
            }
            this.tireTree = newTireTree;
            log.info("Geo\u5b9a\u4f4d\u6570\u636e\u52a0\u8f7d\u5b8c\u6210,SIZE:{}", (Object)list.size());
        }
        catch (Exception e) {
            log.error("Geo\u5b9a\u4f4d\u70b9\u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
        }
    }

    public GeoHash transformGeoHash(WGS84Point point, CoordinateSystem coordinateSystem) {
        double latitude = point.getLatitude();
        double longitude = point.getLongitude();
        Point gcj02 = null;
        if (coordinateSystem == CoordinateSystem.WGS84) {
            gcj02 = GpsCoordinateUtils.calWGS84ToGCJ02(latitude, longitude);
        }
        if (coordinateSystem == CoordinateSystem.BD09) {
            gcj02 = GpsCoordinateUtils.calBD09toGCJ02(latitude, longitude);
        }
        if (Objects.nonNull(gcj02)) {
            latitude = gcj02.getLatitude();
            longitude = gcj02.getLongitude();
        }
        return GeoHash.withCharacterPrecision((double)latitude, (double)longitude, (int)8);
    }
}

