/**
 * Copyright (c) 2022, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.geo.local.common.enums;

import com.google.common.collect.Sets;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Set;

/**
 * 描述: 地域
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2022/1/5 10:58
 */
@Getter
public enum AdArea {
    //山东、江苏、安徽、江西、浙江、福建、上海
    HUA_DONG(1, "华东地区", Sets.newHashSet("31", "32", "33", "34", "35", "36", "37")),
    //北京、天津、河北、山西、内蒙古
    HUA_BEI(2, "华北地区", Sets.newHashSet("11", "12", "13", "14", "15")),
    //湖北、湖南、河南
    HUA_ZH(3, "华中地区", Sets.newHashSet("41", "42", "43")),
    //广东、广西、海南
    HUA_NAN(4, "华南地区", Sets.newHashSet("44", "45", "46")),
    //辽宁、吉林、黑龙江
    DONG_BEI(5, "东北地区", Sets.newHashSet("21", "22", "23")),
    //宁夏、新疆、青海、陕西、甘肃
    XI_BEI(6, "西北地区", Sets.newHashSet("61", "62", "63", "64", "65")),
    //四川、云南、贵州、西藏、重庆
    XI_NAN(7, "西南地区", Sets.newHashSet("50", "51", "52", "53", "54")),
    //台湾、香港、澳门
    GANG_AO_TAI(8, "港澳台", Sets.newHashSet("71", "81", "82")),

    OTHER(99, "其他", Sets.newHashSet());

    private Integer code;
    private String rankDesc;
    private Set<String> citySet;

    AdArea(Integer code, String rankDesc, Set<String> citySet) {
        this.code = code;
        this.rankDesc = rankDesc;
        this.citySet = citySet;
    }

    public static AdArea getAdAreaByCode(String adCode) {
        if (StringUtils.isBlank(adCode)) {
            return OTHER;
        }
        AdArea[] adAreas = AdArea.values();
        for (int i = 0; i < adAreas.length; i++) {
            Set<String> citySet = adAreas[i].getCitySet();
            if (citySet.stream().anyMatch(prefix -> adCode.startsWith(prefix))) {
                return adAreas[i];
            }
        }
        return OTHER;
    }
}
