package cn.com.duiba.geo.local.common.enums;

import com.google.common.collect.Sets;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Set;

/**
 * 描述: 城市等级
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2022/1/5 10:58
 */
@Getter
public enum AdRank {

    // "北京", "天津", "沈阳市", "上海", "南京市", "苏州市", "无锡市", "杭州市", "宁波市", "青岛市", "郑州市", "武汉市", "长沙市", "东莞市", "广州市", "深圳市", "重庆", "成都市", "西安市"
    TIER_FIRST_CITY(1, "一线城市", Sets.newHashSet("11", "12", "2101", "31", "3201", "3205", "3202", "3301", "3302", "3702", "4101", "4201", "4301", "4419", "4401", "4403", "50", "5101", "6101")),

    // "保定市", "石家庄市", "太原市", "大连市", "长春市", "哈尔滨市", "常州市", "南通市", "徐州市", "嘉兴市", "金华市", "绍兴市", "台州市", "温州市", "合肥市", "福州市", "泉州市", "厦门市", "南昌市", "济南市", "潍坊市", "烟台市", "佛山市", "惠州市", "中山市", "南宁市", "贵阳市", "昆明市", "兰州市", "乌鲁木齐市"
    TIER_SECOND_CITY(2, "二线城市", Sets.newHashSet("1306", "1301", "1401", "2102", "2201", "2301", "3204", "3206", "3203", "3304", "3307", "3306", "3310", "3303", "3401", "3501", "3505", "3502", "3601", "3701", "3707", "3706", "4406", "4413", "4420", "4501", "5201", "5301", "6201", "6501")),

    // "沧州市", "邯郸市", "廊坊市", "秦皇岛市", "唐山市", "邢台市", "包头市", "呼和浩特市", "鞍山市", "吉林市", "大庆市", "淮安市", "连云港市", "泰州市", "宿迁市", "盐城市", "扬州市", "镇江市", "湖州市", "蚌埠市", "滁州市", "阜阳市", "铜陵市", "芜湖市", "宁德市", "莆田市", "漳州市", "赣州市", "九江市", "上饶市", "宜春市", "菏泽市", "济宁市", "临沂市", "威海市", "淄博市", "洛阳市", "南阳市", "商丘市", "新乡市", "信阳市", "许昌市", "驻马店市", "黄冈市", "荆州市", "襄阳市", "宜昌市", "常德市", "衡阳市", "湘潭市", "岳阳市", "株洲市", "潮州市", "江门市", "揭阳市", "汕头市", "湛江市", "肇庆市", "珠海市", "其他", "桂林市", "柳州市", "海口市", "三亚市", "德阳市", "绵阳市", "遵义市", "曲靖市", "咸阳市", "西宁市", "银川市"
    TIER_THIRD_CITY(3, "三线城市", Sets.newHashSet("1309", "1304", "1310", "1303", "1302", "1305", "1502", "1501", "2103", "2202", "2306", "3208", "3207", "3212", "3213", "3209", "3210", "3211", "3305", "3403", "3411", "3412", "3407", "3402", "3509", "3503", "3506", "3607", "3604", "3611", "3609", "3717", "3708", "3713", "3710", "3703", "4103", "4113", "4114", "4107", "4115", "4110", "4117", "4211", "4210", "4206", "4205", "4307", "4304", "4303", "4306", "4302", "4451", "4407", "4452", "4405", "4408", "4412", "4404", "4503", "4502", "4601", "4602", "5106", "5107", "5203", "5303", "6104", "6301", "6401")),

    CITY_OTHER(99, "其他", Sets.newHashSet());

    private Integer code;
    private String rankDesc;
    private Set<String> citySet;

    AdRank(Integer code, String rankDesc, Set<String> citySet) {
        this.code = code;
        this.rankDesc = rankDesc;
        this.citySet = citySet;
    }

    public static AdRank getAdRankByCityName(String code) {
        if (StringUtils.isBlank(code)) {
            return CITY_OTHER;
        }
        AdRank[] adRanks = AdRank.values();
        for (int i = 0; i < adRanks.length; i++) {
            AdRank adRank = adRanks[i];
            if (adRank.citySet.stream().anyMatch(prefix -> code.startsWith(prefix))) {
                return adRank;
            }
        }
        return CITY_OTHER;
    }

}