package cn.com.duiba.geo.local.common.tire;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TireTreeNode {

    private TireTreeNode[] childs;

    private TireTreeNodeShim payload;

    TireTreeNodeShim getPayload() {
        return payload;
    }

    /**
     * 插入
     * @param policy 插入策略
     */
    final int insert(char[] chars,int level,TireTreeNodePolicy policy,TireTreeNodeShim payload) {
        if(chars.length==0){
            throw new IllegalArgumentException("字典树解析字符串不能为空");
        }
        if(childs==null){
            childs = new TireTreeNode[policy.charSize()];
        }
        int index = policy.charIndex(chars[level]);
        if(childs[index]==null){
            childs[index] = new TireTreeNode();
        }
        TireTreeNode child = childs[index];
        if(level==chars.length-1){
            child.payload = payload;
            return level + 1;
        }
        return child.insert(chars,level+1,policy,payload);
    }

    /**
     * 精准查询
     */
    final TireTreeNode find(char[] chars,int level,TireTreeNodePolicy policy){
        if(chars.length ==level){
            return this;
        }
        if(Objects.isNull(childs)){
            return null;
        }
        int index = policy.charIndex(chars[level]);
        TireTreeNode node = childs[index];
        if(Objects.isNull(node)){
            return null;
        }
        return node.find(chars,level+1,policy);
    }

    /**
     * 递归,把查询的链路付到list
     */
    final void findToList(char[] chars,int level,LinkedList<TireTreeNode> nodes,TireTreeNodePolicy policy) {

        if(Objects.nonNull(this.payload)){
            nodes.add(this);
        }
        if(level>=chars.length){
            return;
        }
        int childIndex = policy.charIndex(chars[level]);
        if(childs==null || Objects.isNull(childs[childIndex])){
            return;
        }
        TireTreeNode node = childs[childIndex];
        node.findToList(chars,level+1,nodes,policy);
    }

    /**
     * 延伸查询，如果自己没找到，就遍历孩子递归延伸查找
     * @param list 结果集
     */
    final void findInDeep(List<TireTreeNode> list) {
        if(Objects.isNull(childs)){
            return;
        }
        for(TireTreeNode child:childs){
            if(Objects.isNull(child)){
                continue;
            }
            if(Objects.nonNull(child.payload)){
                list.add(child);
                continue;
            }
            child.findInDeep(list);
        }
    }

    @Override
    public String toString() {
        return "TireTreeNode{" + "code='" + Optional.ofNullable(this.payload).map(TireTreeNodeShim::getTireTreeKey).orElse(null) + '}';
    }

}
