package cn.com.duiba.geo.local.dao;

import cn.com.duiba.geo.local.domain.entity.AdministrativeDivisionDO;
import cn.com.duiba.geo.local.tool.CsvUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import javax.annotation.PostConstruct;
import java.util.List;

@Repository
public class AdministrativeDivisionDao {

    private List<AdministrativeDivisionDO> simpleList;

    @PostConstruct
    public void init() {
        List<String[]> read = CsvUtils.read("tb_geo_administrative_division.csv");
        read.forEach(e -> {
            simpleList.add(transfer(e));
        });
    }

    public List<AdministrativeDivisionDO> findSimpleAll() {
        return simpleList;
    }


    public AdministrativeDivisionDO transfer(String[] data) {
        AdministrativeDivisionDO divisionDO = new AdministrativeDivisionDO();

        divisionDO.setCode(StringUtils.isBlank(data[2])? null : data[2].replace("\"", ""));
        divisionDO.setName(StringUtils.isBlank(data[2])? null : data[2].replace("\"", ""));
        divisionDO.setLevel(Integer.valueOf(data[2].replace("\"", "")));
        return divisionDO;
    }

}
