package cn.com.duiba.geo.local.dao;

import cn.com.duiba.geo.local.domain.entity.GeoPointDO;
import cn.com.duiba.geo.local.tool.CsvUtils;
import org.springframework.stereotype.Repository;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

@Repository
public class GeoPointDao {

    private List<GeoPointDO> list;

    @PostConstruct
    public void init() {
        List<String[]> read = CsvUtils.read("tb_geo_point.csv");
        read.forEach(e -> {
            list.add(transfer(e));
        });
    }

    public List<GeoPointDO> findAll() {

        return list;
    }

    public GeoPointDO transfer(String[] data) {
        GeoPointDO pointDO = new GeoPointDO();

        pointDO.setId(Long.valueOf(data[0].replace("\"", "")));
        pointDO.setAdCode(data[3].replace("\"", ""));
        pointDO.setGeoHash(data[4].replace("\"", ""));
        pointDO.setLatitude(Double.valueOf(data[5].replace("\"", "")));
        pointDO.setLongitude(Double.valueOf(data[6].replace("\"", "")));
        pointDO.setMaster(data[7].replace("\"", "").equals("1") ? true : false);
        pointDO.setGmtCreate(Date.from(LocalDateTime.parse(data[1].replace("\"", "")).atZone(ZoneId.systemDefault()).toInstant()));
        pointDO.setGmtModified(Date.from(LocalDateTime.parse(data[2].replace("\"", "")).atZone(ZoneId.systemDefault()).toInstant()));

        return pointDO;
    }

}
