package cn.com.duiba.geo.local.remote;

import ch.hsr.geohash.GeoHash;
import ch.hsr.geohash.WGS84Point;
import cn.com.duiba.geo.local.dto.CoordinateSystem;
import cn.com.duiba.geo.local.dto.GeoInfoDto;
import cn.com.duiba.geo.local.dto.Point;
import cn.com.duiba.geo.local.service.point.GeoPointService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author liuyao
 */
@Slf4j
@Service
public class RemoteGeoLocalService {

    @Resource
    private GeoPointService geoPointService;

    public GeoInfoDto findGeoInfoByGeoHash(String geoHash, CoordinateSystem coordinateSystem) {
        if (geoHash.length() > GeoPointService.GEO_HASH_LENGTH) {
            geoHash = geoHash.substring(0, GeoPointService.GEO_HASH_LENGTH);
        }
        GeoHash sourceGeoHash = GeoHash.fromGeohashString(geoHash);
        if (coordinateSystem == CoordinateSystem.GCJ02 || coordinateSystem == null) {
            return geoPointService.findGeoInfoDto(sourceGeoHash);
        }
        WGS84Point point = sourceGeoHash.getOriginatingPoint();
        GeoHash gcj02Hash = geoPointService.transformGeoHash(point, coordinateSystem);
        return geoPointService.findGeoInfoDto(gcj02Hash);
    }

    public GeoInfoDto findGeoInfoByPoint(Point point, CoordinateSystem coordinateSystem) {
        WGS84Point params = new WGS84Point(point.getLatitude(), point.getLongitude());
        GeoHash gcj02Hash = geoPointService.transformGeoHash(params, coordinateSystem);
        return geoPointService.findGeoInfoDto(gcj02Hash);
    }


}
