package cn.com.duiba.geo.local.service.ad;

import cn.com.duiba.geo.local.common.tire.TireTreeNodeShim;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;

@Data
public class AdministrativeDivisionTreeNode implements TireTreeNodeShim {

    private static final LinkedHashMap<Integer,Integer> CODE_LENGTH_FOR_LEVEL = Maps.newLinkedHashMap();
    static{
        CODE_LENGTH_FOR_LEVEL.put(1,2);
        CODE_LENGTH_FOR_LEVEL.put(2,4);
        CODE_LENGTH_FOR_LEVEL.put(3,6);
        CODE_LENGTH_FOR_LEVEL.put(4,9);
        CODE_LENGTH_FOR_LEVEL.put(5,12);
    }

    private static final Pattern PATTERN = Pattern.compile("^0*$");

    private String code;

    private String name;

    private int level;

    /**
     * 500000 1 - > 50,500000 2-> 5000
     */
    @Override
    public String getTireTreeKey() {
        if(StringUtils.isBlank(code)){
            return "";
        }
        return analysisCode(code,level);
    }

    /**
     * 根据行政区划等级解析出有效的部分
     * @param code 源码
     * @return 行政区划有效的部分
     */
    public static String analysisCode(String code){
        int level = analysisLevelByCode(code);
        return analysisCode(code,level);
    }

    private static String analysisCode(String code,int level){
        //1.以0把code补全到12位
        String fullCode = buildFullAdCode(code);
        int end = CODE_LENGTH_FOR_LEVEL.getOrDefault(level,0);
        return fullCode.substring(0,end);
    }

    public static int analysisLevelByCode(String code){
        if(StringUtils.isBlank(code)){
            return 0;
        }
        String fullCode = buildFullAdCode(code);
        List<String> codeList = Lists.newLinkedList();
        for(int level:CODE_LENGTH_FOR_LEVEL.keySet()){
            int start = CODE_LENGTH_FOR_LEVEL.getOrDefault(level-1,0);
            int end = CODE_LENGTH_FOR_LEVEL.getOrDefault(level,0);
            codeList.add(fullCode.substring(start,end));
        }
        int level = 0;
        int index = 0;
        for(String item:codeList){
            index ++;
            if(!PATTERN.matcher(item).find()){
                level = index;
            }
        }
        return level;
    }

    private static String buildFullAdCode(String code){
        StringBuilder builder = new StringBuilder(code);
        int def = 12 - code.length();
        for(int i=0;i<def;i++){
            builder.append(0);
        }
        return builder.toString();
    }

}
