package cn.com.duiba.geo.local.service.point;

import cn.com.duiba.geo.local.common.tire.TireTreeNodePolicy;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liuyao
 */
public class GeoPointTireTreePolicy implements TireTreeNodePolicy {

    private static final char[] BASE32 = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f',
            'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z' };

    private final static Map<Character, Integer> DECODE_MAP = new HashMap<>();

    static {
        int sz = BASE32.length;
        for (int i = 0; i < sz; i++) {
            DECODE_MAP.put(BASE32[i], i);
        }
    }

    @Override
    public int charIndex(char item) {
        return DECODE_MAP.getOrDefault(item,0);
    }

    @Override
    public int charSize() {
        //base32会产生32种结果
        return BASE32.length;
    }
}
