/**
 * Copyright (c) 2022, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.geo.local.tool;

import lombok.extern.slf4j.Slf4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

/**
 * 描述: 读取csv文件
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2022/4/18 16:37
 */
@Slf4j
public class CsvUtils {

    public static List<String[]> read(String filePath) {

        List<String[]> result = new LinkedList<>();
        String line = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(CsvUtils.class.getResourceAsStream("/" + filePath)))) {
            while ((line = reader.readLine()) != null) {
                result.add(line.split(","));
            }
        } catch (IOException e) {
            log.error("read geo file error, ", e);
        }

        return result;
    }

}
