package cn.com.duiba.goods.center.api.remoteservice.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 虚拟商品渠道枚举
 *
 * @author zouweixiang
 * @date 2021/07/17
 */
public enum VisualItemChannelEnum {


    /**
     * 虚拟商品充值渠道状态码
     */
    FULU("fulu", "福禄"),
    HUAZHU("huazhu", "华住"),
    BILIBILI("bilibili", "哔哩哔哩"),
    PU_SHANG("pushang", "浦上"),
    SHANG_YU("shangyu", "尚娱"),
    QING_TIAN("qingtian", "晴天"),
    ALIPAY_IGR("alipayIGR", "支付宝立减金"),
    /*SUCCESS("success","成功"),
    FAIL("fail","失败"),
    TIME_OUT("timeout","超时"),*/
    ;

    String code;
    String desc;

    VisualItemChannelEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取描述
     *
     * @param code
     * @return
     */
    public static String getDescByCode(String code) {
        for (VisualItemChannelEnum channelEnum : VisualItemChannelEnum.values()) {
            if (StringUtils.equals(channelEnum.getCode(), code)) {
                return channelEnum.getDesc();
            }
        }
        return null;
    }


}
