/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.marketing.MarketingItemCreditsSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AppItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.CreditsSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.ExchangeTypeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MarketingSkuUtils {
    private static final String SEPARATOR_ATTRIBUTE_SEMICOLON = ";";
    private static final String SEPARATOR_ATTRIBUTE_COLON = ":";

    public static List<CreditsSkuDto> getCreditsSkuList(List<AppItemSkuDto> skuList, List<MarketingItemCreditsSkuDto> marketingItemCreditsSkuList, Integer exchangeType, Integer creditsRate) {
        if (null == skuList || skuList.isEmpty() || null == exchangeType) {
            return null;
        }
        ArrayList newSkuList = Lists.newArrayList();
        HashMap<Long, MarketingItemCreditsSkuDto> marketingItemCreditsSkuMap = new HashMap();
        if (marketingItemCreditsSkuList != null && !marketingItemCreditsSkuList.isEmpty()) {
            marketingItemCreditsSkuMap = marketingItemCreditsSkuList.stream().collect(Collectors.toMap(MarketingItemCreditsSkuDto::getSkuId, m -> m, (k1, k2) -> k1));
        }
        for (AppItemSkuDto sku : skuList) {
            if (sku.getSaleStatus() != null && sku.getSaleStatus() == 0) continue;
            CreditsSkuDto skuObj = new CreditsSkuDto();
            skuObj.setSkuId(sku.getId());
            skuObj.setAttributeValue(MarketingSkuUtils.getAttributeValue(sku.getAttributeJson()));
            skuObj.setFacePrice(sku.getFacePrice());
            skuObj.setSalePrice(sku.getSalePrice());
            skuObj.setImgUrl(sku.getImgUrl());
            skuObj.setRemaining(sku.getRemaining());
            skuObj.setTotalStock(sku.getTotalStock());
            skuObj.setStartDay(sku.getStartDay());
            skuObj.setEndDay(sku.getEndDay());
            skuObj.setCurrentStock(sku.getCurrentStock());
            skuObj.setCurrentTotalStock(sku.getCurrentTotalStock());
            skuObj.setCostPrice(sku.getCostPrice());
            MarketingSkuUtils.setMarketingInfo(exchangeType, creditsRate, marketingItemCreditsSkuMap, sku, skuObj);
            newSkuList.add(skuObj);
        }
        return newSkuList;
    }

    public static String getAttributeValue(String attributeJson) {
        if (StringUtils.isBlank((CharSequence)attributeJson)) {
            return null;
        }
        String[] attrArray = attributeJson.split(SEPARATOR_ATTRIBUTE_SEMICOLON);
        StringBuilder newSkuStr = new StringBuilder();
        for (String attrStr : attrArray) {
            Integer i = attrStr.indexOf(SEPARATOR_ATTRIBUTE_COLON, attrStr.indexOf(SEPARATOR_ATTRIBUTE_COLON) + 1);
            String newValue = i != -1 ? attrStr.substring(0, attrStr.lastIndexOf(SEPARATOR_ATTRIBUTE_COLON)) : attrStr;
            newSkuStr.append(newValue).append(SEPARATOR_ATTRIBUTE_SEMICOLON);
        }
        return newSkuStr.toString().substring(0, newSkuStr.length() - 1);
    }

    private static void setMarketingInfo(Integer exchangeType, Integer creditsRate, Map<Long, MarketingItemCreditsSkuDto> marketingItemCreditsSkuMap, AppItemSkuDto sku, CreditsSkuDto skuObj) {
        if (exchangeType.intValue() == ExchangeTypeEnum.AUTOMATIC.getCode().intValue()) {
            skuObj.setMarketingCredits((long)Math.ceil((double)(sku.getSalePrice() * (long)creditsRate.intValue()) / 100.0));
            skuObj.setMarketingPrice(0L);
            skuObj.setConfigPureCredits((long)Math.ceil((double)(sku.getSalePrice() * (long)creditsRate.intValue()) / 100.0));
        } else {
            MarketingItemCreditsSkuDto dto = marketingItemCreditsSkuMap.get(sku.getId());
            skuObj.setMarketingCredits(dto.getCustomCredits());
            skuObj.setMarketingPrice(dto.getCustomPrice());
            skuObj.setConfigPureCredits(dto.getConfigPureCredits());
        }
    }
}

