package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * 兑吧虚拟商品子类型枚举
 *
 * 只有当商品时虚拟商品时子类型才生效
 * @see cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto#subType
 * @author zhangruofan
 * @date 2019/02/02
 */
public enum VirtualSubType {
    /**
     * 支付宝转账
     */
    ALI_PAY(10, "通过支付宝用户id转账"),

    /**
     * 月补签卡
     */
    RESIGN_MONTH_CARD(11, "月补签卡"),
    /**
     * 衢州招行活动专用充值商品
     */
    QZZH_DUIBA_VIRTUAL(12, " 衢州招行活动专用商家自充"),

    /**
     * 多张集卡
     */
    COLLECT_CARDS(13, "多张集卡"),
    /**
     * 鼎信充值
     */
    JXABC_DUIBA_VIRTUAL(14, "鼎信充值"),
    /**
     * oppo微信红包定制
     * */
    OPPO_WECHAT_REDPACK_DUIBA_VIRTUAL(15, "oppo微信红包"),
    /**
     * 浙江中行话费
     */
    ZHEJIANG_ZHONGHANG_DUIBA_VIRTUAL(16,"浙江中行话费"),

    /**
     * 苏州招行-八维通优惠券
     */
    BWT_COUPON_DUIBA_VIRTUAL(17,"苏州招行八维通优惠券"),
    /**
     * 南京中信话费虚拟商品
     */
    NJZX_DUIBA_VIRTUAL(18,"南京中信话费虚拟商品"),

    /**
     * 工行卡中心立减金虚拟商品
     */
    ICBC_CARD_CENTER_DEDUCT_COUPON_DUIBA_VIRTUAL(19, "工行卡中心立减金虚拟商品"),

    /**
     * 南京中信乐享券
     */
    NJZX_LXQ_DUIBA_VIRTUAL(20,"南京中信乐享券"),

    /**
     * 苏州中信乐享券
     */
    SZZX_LXQ_DUIBA_VIRTUAL(21,"苏州中信乐享券"),

    /**
     * 陕西中烟虚拟商品
     */
    SXZY_DUIBA_VIRTUAL(22, "陕西中烟虚拟商品"),

    /**
     * 上海联通虚拟商品
     */
    SHANGHAI_UNICOM_DUIBA_VIRTUAL(23,"上海联通虚拟商品"),


    /**
     * 成都银行自充话费
     */
    CHENGDU_BANK_DUIBA_VIRYUAL(24,"成都银行自充话费"),

    /**
     * 工行卡中心电子券
     */
    ICBC_E_COUPON_DUIBA_VIRTUAL(26, "工行卡中心电子券"),

    /**
     * 泰康在线虚拟商品
     */
    TKONLINE_DUIBA_VIRYUAL(25, "泰康在线虚拟商品"),

    /**
     * 湖南联通虚拟商品
     */
    HNLT_DUIBA_VIRTUAL(27, "湖南联通虚拟商品"),

    /**
     * 古茗虚拟商品
     */
    GUMING_DUIBA_VIRTUAL(28, "古茗虚拟商品"),

    /**
     * 银联云闪付小程序专属红包
     */
    UNION_EXCLUSIVE_RED_PACKET_DUIBA_VIRTUAL(29, "银联云闪付小程序专属红包"),
    /**
     * 爱奇艺爱豆虚拟商品
     */
    IQIYI_DUIBA_VIRTUAL(30,"爱奇艺爱豆虚拟商品"),

    /**
     * 泰州农行虚拟商品
     */
    TAIZHOU_ABC_DUIBA_VIRTUAL(31, "泰州农行虚拟商品"),

    /**
     * 招行行外发奖虚拟商品
     */
    CMB_CHINA_OUTWARD_REWARD(32,"招行行外发奖虚拟商品"),

    /**
     * 携程虚拟商品
     */
    XIECHENG_DUIBA_VIRTUAL(33,"携程虚拟商品"),

    JD_COUPON_VIRTUAL(40, "京东-优惠券"),
    JD_POINTS_VIRTUAL(41, "京东-店铺积分"),
    JD_BEAN_VIRTUAL(42, "京东-京豆"),

    /**
     * 光大萌宠
     */
    GD_PET_VIRTUAL(43, "光大萌宠虚拟商品"),

    /**
     * 湖南联通虚拟商品--发积分
     */
    HNLT_JIFEN_DUIBA_VIRTUAL(44, "湖南联通虚拟商品--发积分"),

    /**
     * 泰隆银行虚拟商品
     */
    TAI_LONG_VIRTUAL(45,"泰隆银行虚拟商品"),

    /**
     * 地素虚拟商品--投放卡券
     */
    DI_SU_VIRTUAL(46,"地素虚拟商品--投放卡券"),

    /**
     * 湖南联通虚拟话费券
     */
    HNLT_VIRTUAL_COUPON(47,"湖南联通虚拟话费券"),

    /**
     * 银联云闪付小程序直接抽奖
     */
    UNION_EXCLUSIVE_DIRECT_DRAW_DUIBA_VIRTUAL(48, "银联云闪付小程序直接抽奖"),

    /**
     * 重庆移动虚拟商品
     */
    CQYD_DUIBA_VIRTUAL(49,"重庆移动虚拟商品"),

    /**
     * 深圳建行-券码
     */
    SZJH_COUPON(50,"深圳建行-券码"),
    /**
     * 深圳建行-消费补贴
     */
    SZJH_CONSUMPTION_SUBSIDY(51,"深圳建行-消费补贴"),

    /**
     * 宁波银行券码
     */
    NINGBO_COUPON_DUIBA_VIRTUAL(52, "宁波银行券码"),

    /**
     * 浙江银联话费券
     */
    ZJYL_BILL_VOUCHER(53, "浙江联通话费券"),

    /**
     * 浙江联通权益
     */
    ZJYL_RIGHT(54, "浙江联通权益"),

    /**
     * 浦发银行金豆（积分）
     */
    PF_BANK_BEAN(55, "浦发银行金豆"),

    /**
     * 滔博专属优惠券
     */
    TOP_SPORTS_COUPON(56, "滔博专属优惠券"),

    /**
     * 大都会微信红包
     */
    BIG_CITY_MEETING_DUIBA_VIRTUAL(57, "大都会微信红包"),
    /**
     * 中国联通-权益中心
     */
    UNICOM_TRADE_CENTER(58, "中国联通权益中心"),
    /**
     *  成都银行-权益
     */
    CHENGDU_BANK_EQUITY(59,"成都银行权益"),
    /**
     * 平安银行-虚拟商品
     */
    PAYH_DUIBA_VIRTUAL(60, "平安银行虚拟商品"),
    /**
     * 嘉兴农行
     */
    JIAXING_WEINENG_VIRTUAL(61, "嘉兴农行微能虚拟商品"),
    /**
     * 南京银行-N世界活动券
     */
    NJBANK_N_WORLD_COUPON(62, "南京银行N世界活动券"),
    /**
     * 南京银行-N世界积分充值
     */
    NJBANK_N_WORLD_CREDIT(63, "南京银行N世界积分"),

    /**
     * 浙商证券-虚拟商品
     */
    ZSZQ_HF_DUIBA_VIRTUAL(64, "浙商证券话费积分"),

    /**
     * 口味王奖品
     */
    KOUWEIWANG_PRIZE(65, "口味王奖品"),

    /**
     * 杭州银行-开门大吉虚拟商品
     */
    HZBANK_KMH_PRIZE(66, "杭州银行-开门大吉虚拟商品"),
    /**
     * 南京银行优惠券
     */
    NJBANK_COUPON(67, "南京银行-优惠券"),
    /**
     * 南京银行-代币充值
     */
    NJBANK_CREDIT(68, "南京银行-代币"),
    ;

    private Integer code;
    private String desc;

    VirtualSubType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
