package cn.com.duiba.goods.center.api.remoteservice.tool.sku;

import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AppItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.SkuAttributeNode;
import cn.com.duiba.goods.center.api.remoteservice.tool.UnitUtils;
import org.apache.commons.lang.StringUtils;

/**
 * @Desc appItemSku解析器
 * @Author xuwei
 * @Date 2018/11/12
 */
public class AppItemSkuResolver extends AbstractSkuResolver<AppItemSkuDto, SkuAttributeNode.AppItemSkuInfo> {

    @Override
    protected AppItemSkuDto toDto(Long appItemId, Long itemId, String attributeJson, SkuAttributeNode.AppItemSkuInfo skuInfo) {
        AppItemSkuDto appItemSku = new AppItemSkuDto();
        appItemSku.setAppItemId(appItemId);
        appItemSku.setItemId(itemId);
        appItemSku.setAttributeJson(attributeJson);
        appItemSku.setId(parseString2Long(skuInfo.getId()));
        appItemSku.setFacePrice(UnitUtils.transformYuan2Fen(skuInfo.getFacePrice()));
        appItemSku.setSalePrice(UnitUtils.transformYuan2Fen(skuInfo.getSalePrice()));
        //成本价
        appItemSku.setCostPrice(UnitUtils.transformYuan2Fen(skuInfo.getCostPrice()));
        appItemSku.setSupplyPrice(UnitUtils.transformYuan2Fen(skuInfo.getSupplyPrice()));
        appItemSku.setMerchantCoding(skuInfo.getMerchantCoding());
        appItemSku.setRemaining(skuInfo.getRemaining());
        appItemSku.setPreRemaining(skuInfo.getPreRemaining());
        appItemSku.setImgUrl(skuInfo.getImgUrl());
        appItemSku.setStockId(parseString2Long(skuInfo.getStockId()));
        appItemSku.setItemSkuId(parseString2Long(skuInfo.getItemSkuId()));
        appItemSku.setCardLibraryId(parseString2Long(skuInfo.getCardLibraryId()));
        appItemSku.setSaleStatus(skuInfo.getSaleStatus());
        return appItemSku;
    }

    @Override
    protected String getAttributeJson(AppItemSkuDto sku) {
        return sku.getAttributeJson();
    }

    @Override
    protected SkuAttributeNode.AppItemSkuInfo toVo(AppItemSkuDto sku) {
        SkuAttributeNode.AppItemSkuInfo skuInfo = new SkuAttributeNode.AppItemSkuInfo();
        skuInfo.setId(parseLong2String(sku.getId()));
        skuInfo.setFacePrice(UnitUtils.transformFen2Yuan(sku.getFacePrice()));
        skuInfo.setSalePrice(UnitUtils.transformFen2Yuan(sku.getSalePrice()));
        //成本价
        skuInfo.setCostPrice(UnitUtils.transformFen2Yuan(sku.getCostPrice()));
        skuInfo.setSupplyPrice(UnitUtils.transformFen2Yuan(sku.getSupplyPrice()));
        skuInfo.setMerchantCoding(sku.getMerchantCoding());
        skuInfo.setImgUrl(sku.getImgUrl());
        skuInfo.setStockId(parseLong2String(sku.getStockId()));
        skuInfo.setItemSkuId(parseLong2String(sku.getItemSkuId()));
        skuInfo.setRemaining(sku.getRemaining());
        skuInfo.setPreRemaining(sku.getPreRemaining());
        skuInfo.setCardLibraryId(parseLong2String(sku.getCardLibraryId()));
        skuInfo.setSaleStatus(sku.getSaleStatus());
        return skuInfo;
    }

    @Override
    protected SkuAttributeNode.AppItemSkuInfo getSkuInfo(SkuAttributeNode<SkuAttributeNode.AppItemSkuInfo> node) {
        //从前节点获取图片
        SkuAttributeNode.AppItemSkuInfo skuInfo = node.getSkuInfo();
        // 如果sku单规格图片为空 则取上层图片，不为空就不处理
        if (skuInfo != null && StringUtils.isBlank(skuInfo.getImgUrl())) {
            skuInfo.setImgUrl(node.getImgUrl());
        }
        return super.getSkuInfo(node);
    }

    @Override
    protected void postNode(SkuAttributeNode<SkuAttributeNode.AppItemSkuInfo> headNode, SkuAttributeNode<SkuAttributeNode.AppItemSkuInfo> node) {
        //目前只有跟节点存储图片信息，从叶节点sku中获取图片
        SkuAttributeNode.AppItemSkuInfo skuInfo = node.getSkuInfo();
        if (skuInfo != null) {
            if (headNode.getImgUrl() == null) {
                headNode.setImgUrl(skuInfo.getImgUrl());
            }
        }
        super.postNode(headNode, node);
    }
}
