package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.AppItemClassifyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.AppItemClassifyRelationDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.javatuples.Pair;

import java.util.List;
import java.util.Map;

/**
 * Created by xiaoxuda on 2016/11/17.
 */
@AdvancedFeignClient
public interface RemoteAppItemClassifyService {
    /**
     * 根据id查询商品分类信息
     * @param id
     * @return
     */
    public DubboResult<AppItemClassifyDto> find(Long id);

    /**
     * 删除relation
     * @param appItemId
     * @return
     */
    public DubboResult<Integer> deleteRelationAppItem(Long appItemId);

    /**
     * findByIds
     * @param ids
     * @return
     */
    List<AppItemClassifyDto> findByIds(List<Long> ids);

    /**
     * findAllByAppId
     * @param appId
     * @return
     */
    List<AppItemClassifyDto> findAllByAppId(Long appId);

    /**
     * update
     * @param appItemClassifyDto
     */
    public void update(AppItemClassifyDto appItemClassifyDto);


    /**
     * 自定义分类商品排序
     */
    public void sortByClassifyPayload(Long classifyId, Long appItemId,Long operatingActivityId ,Integer startPayload, Integer endPayload);

    /**
     * 自定义分类商品置顶
     */
    public void setTop(Long classifyId, Long appItemId,Long operatingActivityId);

    /**
     * 自定义分类商品取消置顶
     */
    public void cancleTop(Long classifyId, Long appItemId,Long operatingActivityId);

    public Long findByCount(Map<String, Object> params);

    public List<AppItemClassifyDto> findByLimit(Map<String, Object> params);

    public Integer deleteClassifyAllAppItem(Long classifyId);

    public int deleteClassifyAppItem(Long classifyId, Long appItemId);

    public int batchInsert(List<Map<String, Object>> classifyRelation);

    public List<Long> findAllAppItemById(Long classifyId);

    public int deleteAppItemRelation(List<Long> ids, Long appId);

    public void insert(AppItemClassifyDto appItemClassifyDO);

    public Integer findMaxPayload(Long classifyId);

    public Integer updatePayload(Long appItemId, Long classifyId, Integer payload);


    /**
     * 查询开发者分类总数
     * @param appId
     * @return
     */
    Long findByCountNew(Long appId);

    /**
     * 分页查询分类列表
     * @param appId
     * @param start
     * @param pageSize
     * @return
     */
    List<AppItemClassifyDto> findByLimitNew(Long appId, int start, int pageSize);

    /**
     * 根据分类id查询分类下所有商品活动
     * @param classifyId
     * @return
     */
    List<AppItemClassifyRelationDto> getByClassifyId(Long classifyId);

    /**
     * 删除关联的活动
     * @param classifyId
     * @param operatingActivityId
     * @return
     */
    int deleteClassifyActivity(Long classifyId, Long operatingActivityId);


    /**
     * 批量删除关联的活动
     * @param ids
     * @param appId
     * @return
     */
    int deleteActivityRelation(List<Long> ids, Long appId);

    /**
     * 根据分类id找出所有的活动id
     * @param classifyId
     * @return
     */
    List<Long> findAllOpActivityIdById(Long classifyId);

    /**
     * 自定义分类排序
     * @param classifyId
     * @param pairs type-id映射
     */
    void sortClassify(Long classifyId, List<Pair<Integer, Long>> pairs);
}
