package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * 券显示给用户的形式
 * Created by sty on 9/27/17.
 */
public enum CouponShowTypeEnum {
    //券码0,条形码1
    COUPON_CODE(0,"券码"),COUPON_BAR_CODE(1,"条形码"),COUPON_SIGN_LINK(2,"签名链接券");
    private  int value;
    private  String description;

    CouponShowTypeEnum(int value,String description) {
        this.value = value;
        this.description=description;
    }


    /**
     * 根据类型，反查枚举类<br/>
     * 若是没找到，返回null
     *
     * @param type 枚举类型
     * @return 枚举类
     */
    public static CouponShowTypeEnum getCouponShowTypeEnum(int type) {

        CouponShowTypeEnum[] values = CouponShowTypeEnum.values();
        for (CouponShowTypeEnum value : values) {
            if (value.getValue() == type) {
                return value;
            }
        }

        return null;
    }

    public int getValue() {
        return value;
    }

    public String getDescription() {
        return description;
    }
}
