package cn.com.duiba.goods.center.api.remoteservice.couponcode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.couponcode.CouponCodeRecoveryLogDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCouponCodeRecoveryLogService {
    public int batchInsert(List<CouponCodeRecoveryLogDto> logs);

    public List<CouponCodeRecoveryLogDto> selectDeleteLogs(Long operationLogId, int offset, int max);

    public Long selectDeleteLogsCount(Long operationLogId);

    /**
     * 根据日志id删除最近n条插入的记录
     * @param operationLogId
     * @param rows
     * @return
     */
    public int deleteByOperationLogIdLatestRows(Long operationLogId, int rows);
}
