package cn.com.duiba.goods.center.api.remoteservice.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 集卡商品类型枚举
 */
public enum CollectGoodsTypeEnum {

    NORMAL(0, "普通集卡"),
    RANDOM_REWARD(1, "随机红包"),
    ;

    private static final ImmutableMap<Integer, CollectGoodsTypeEnum> ALL_MAP;

    static {
        Map<Integer, CollectGoodsTypeEnum> temp = Maps.newHashMap();
        for (CollectGoodsTypeEnum type : values()) {
            temp.put(type.getCode(), type);
        }
        ALL_MAP = ImmutableMap.copyOf(temp);
    }

    /** 类型代码 */
    private Integer code;
    /** 描述 */
    private String desc;

    CollectGoodsTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static CollectGoodsTypeEnum getByCode(Integer code) {
        return ALL_MAP.get(code);
    }
}
