package cn.com.duiba.goods.center.api.remoteservice.sku;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AppItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.RedefineAttributeDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.RedefineSkuDto;

import java.util.List;


@AdvancedFeignClient
public interface RemoteAppItemSkuService {
    /**
     * 根据开发者商品id，查询sku信息
     */
    List<AppItemSkuDto> findSkuListByAppItemId(Long appItemSkuId);

    /**
     * 根据开发者商品id列表，查询sku信息
     */
    List<AppItemSkuDto> findSkuByItemIdList(List<Long> appItemIds);

    Integer saveSku(AppItemSkuDto appItemSkuDto);

    Integer batchSaveSku(List<AppItemSkuDto> appItemSkuDtoList);

    Integer deleteSkuByAppItemId(Long appItemId);

    List<String> reBuildSkuInfo(String extraString);

    List<RedefineSkuDto> getSkuList(List<AppItemSkuDto> skuList);

    List<RedefineAttributeDto> getAttribute(List<AppItemSkuDto> skuList);

	/**
     * 根据skuId集合返回sku的属性信息
     * 返回格式为 白色/XL
     * @param skuIdList
     * @return
     */
    List<RedefineSkuDto> findSkuRedefineValue(List<Long> skuIdList);
}
