package cn.com.duiba.goods.center.api.remoteservice.util;

import cn.com.duiba.api.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ChangeACGTypeApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.ChangeACGTypeDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponQueryParamApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponQueryParamDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;

import java.util.stream.Collectors;

/**
 * @author: zhengjianhao
 * @date: 18/12/5 19:48
 * @description: dcommons下线过程中，对象转换，dcommons下线后去掉
 */
public class GoodsDtoTransferUtils {

	private GoodsDtoTransferUtils() {
	}

	public static GoodsStockApiDto stockToApi(GoodsStockDto stock){
		GoodsStockApiDto stockApi = BeanUtils.copy(stock, GoodsStockApiDto.class);
		if(null != stock && null != stock.getGtype()){
			stockApi.setGtype(GoodsTypeEnum.getGoodsTypeEnum(stock.getGtype().getGtype()));
		}
		return stockApi;
	}

	public static GoodsStockDto apiToStock(GoodsStockApiDto stockApi){
		GoodsStockDto stock = BeanUtils.copy(stockApi, GoodsStockDto.class);
		if(null != stockApi && null != stockApi.getGtype()){
			stock.setGtype(cn.com.duiba.dcommons.enums.GoodsTypeEnum.getGoodsTypeEnum(stockApi.getGtype().getGtype()));
		}
		return stock;
	}

	public static GoodsDirectionalConfigApiDto configToApi(GoodsDirectionalConfigDto config){
		GoodsDirectionalConfigApiDto configApi = BeanUtils.copy(config, GoodsDirectionalConfigApiDto.class);
		if(null != config && null != config.getGtype()){
			configApi.setGtype(GoodsTypeEnum.getGoodsTypeEnum(config.getGtype().getGtype()));
		}
		return configApi;
	}

	public static GoodsDirectionalConfigDto apiToConfig(GoodsDirectionalConfigApiDto configApi){
		GoodsDirectionalConfigDto config = BeanUtils.copy(configApi, GoodsDirectionalConfigDto.class);
		if(null != configApi && null != configApi.getGtype()){
			config.setGtype(cn.com.duiba.dcommons.enums.GoodsTypeEnum.getGoodsTypeEnum(configApi.getGtype().getGtype()));
		}
		return config;
	}

	public static GoodsCouponQueryParamApiDto paramToApi(GoodsCouponQueryParamDto param){
		GoodsCouponQueryParamApiDto paramApi = BeanUtils.copy(param, GoodsCouponQueryParamApiDto.class);
		if(null != param && null != param.getGtype()){
			paramApi.setGtype(GoodsTypeEnum.getGoodsTypeEnum(param.getGtype().getGtype()));
		}
		return paramApi;
	}

	public static ChangeACGTypeApiDto typeToApi(ChangeACGTypeDto type){
		ChangeACGTypeApiDto typeApi = BeanUtils.copy(type, ChangeACGTypeApiDto.class);
		if(null != type && null != type.getGtype()){
			typeApi.setGtype(GoodsTypeEnum.getGoodsTypeEnum(type.getGtype().getGtype()));
		}
		return typeApi;
	}

	public static PCGCategorySellerGoodsDto apiToSellerGoods(PCGCategorySellerGoodsApiDto sellerGoodsApi){
		PCGCategorySellerGoodsDto sellerGoods = BeanUtils.copy(sellerGoodsApi, PCGCategorySellerGoodsDto.class);
		if(null != sellerGoodsApi && null != sellerGoodsApi.getGoodsDirectionalConfigApiDto()){
			sellerGoods.setGoodsDirectionalConfigDto(apiToConfig(sellerGoodsApi.getGoodsDirectionalConfigApiDto()));
		}
		return sellerGoods;
	}

	public static Page<PCGCategorySellerGoodsDto> apiToSellerGoodsPage(Page<PCGCategorySellerGoodsApiDto> pageApi){
		Page<PCGCategorySellerGoodsDto> page = BeanUtils.copy(pageApi, Page.class);
		if(null != pageApi && CollectionUtils.isNotEmpty(pageApi.getList())){
			page.setList(pageApi.getList().stream().map(x-> GoodsDtoTransferUtils.apiToSellerGoods(x)).collect(Collectors.toList()));
		}
		return page;
	}
}
