package cn.com.duiba.goods.center.api.remoteservice.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Map;

import static cn.com.duiba.goods.center.api.remoteservice.enums.UploadImageEnum.BANNER_IMAGE_NEW;
import static cn.com.duiba.goods.center.api.remoteservice.enums.UploadImageEnum.SMALL_IMAGE_NEW;

/**
 * 基础活动DTO
 * Created by xutao on 2017/7/6.
 */
public abstract class BaseImgDto implements Serializable {

    private static final long serialVersionUID = -4945700444205913781L;
    //json图片字符串
    protected String imageJson;

    //新版首页banner
    protected String bannerImgNew;
    //新版缩略图
    protected String smallImgNew;

    private Map<String, String> imageJsonMap = Maps.newHashMap();

    public String getImageJson() {
        return imageJson;
    }

    public void setImageJson(String imageJson) {
        this.imageJson = imageJson;
    }

    public String getImageJsonMap() {
        return JSON.toJSONString(imageJsonMap);
    }

    public void setImageJsonMap(Map<String, String> imageJsonMap) {
        this.imageJsonMap = imageJsonMap;
    }

    public String getBannerImgNew() {
        if (StringUtils.isNotBlank(this.imageJson)) {
            return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
            }).get(BANNER_IMAGE_NEW.getCode());
        }

        return StringUtils.EMPTY;
    }


    public void setBannerImgNew(String bannerImgNew) {
        this.bannerImgNew = bannerImgNew;
        imageJsonMap.put(BANNER_IMAGE_NEW.getCode(), bannerImgNew);
    }

    public String getSmallImgNew() {
        if (StringUtils.isNotBlank(this.imageJson)) {
            return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
            }).get(SMALL_IMAGE_NEW.getCode());
        }

        return StringUtils.EMPTY;
    }

    public void setSmallImgNew(String smallImgNew) {
        this.smallImgNew = smallImgNew;
        imageJsonMap.put(SMALL_IMAGE_NEW.getCode(), smallImgNew);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
