package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;
import java.util.Date;

/**
 * @author JunAngLiu
 * @Title: AppItemSampleDto
 * @Description: 简单 属性
 * @date 2019/4/2918:47
 */
public class AppItemSampleDto implements Serializable {

    private static final long serialVersionUID = 7840977498811756872L;
    private Long id;
    private Long appId;
    private Long itemId;
    private Long batchId;
    private Long credits;
    private Integer minFacePrice;
    private String logo;
    private String title;
    private String subtitle;
    private Integer payload;
    private String customPrice; // 用户自定义商品价格（可分为1-6栏显示，存储结构为json形式的字符串，
    // 面值1:积分1,面值2:积分2...）
    private Date addTime; // 商品加入开发者库的时间。
    private Boolean deleted; // 是否已经删除
    private String status; // 状态（on/off）
    private String subStatus; // 子状态（）
    private Boolean homeDisplay;// 是否首页展示
    private Boolean isOwner; // 是否开发者发布

    private String exchangeTipTemplate;// 兑换提示模板 实物用于 兑换成功文案
    private String alertMessage;// 实物用于 待发货文案

    // --以下为自有实物字段
    private String description;
    private Integer facePrice;
    private Integer limitCount;
    private Integer remaining;
    private Date validEndDate;
    private String smallImage;
    private String whiteImage;
    private String image;

    private String multiImage;
    private String type;// 商品类型，比如 QB，话费充值 等等

    private Integer sourceType; // 来源类型，目前有 普通兑换类型，运营活动类型
    private Long sourceRelationId;//

    private String limitScope;
    private Integer operationsType;
    private String limitTimeBetween;
    private Integer limitEverydayQuantity;
    private String bannerImage;

    private String limitDate; // 兑换日期限制
    private String customTag;
    private Integer subType;

    private Date gmtCreate;
    private Date gmtModified;

    // 会员等级限制添加字段
    private Long vipLimits;
    private Integer vipLimitType;

    private Date autoOffDate; // 定时自动下架日期

    private String devCustomCode; // 开发者的商品ID

    private Long salePrice;// 兑换价格
    private String expressType;// 运费类型 free(包邮)，unity(统一运费)，template(运费模板)
    private Long expressPrice;// 运费价格 选择 统一价 或者 包邮
    private Long expressTemplateId;// 运费模板ID L 选择 模板

    /** added zhengjy 20160520 安全链接 begin */
    private Long sellerId;// 商家id
    /** added zhengjy 20160520 安全链接 end */

    // 分类ID
    private Long classifyId;
    // 商品在分类中的权重值
    private Integer classifyPayload;

    //json图片字符串
    private String imageJson;

    //扩展json信息,目前用来存储了摩拜的积分信息
    private String extraInfo;

    private Long stockId;//关联库存中心的stockId

    public Integer getIsSeries() {
        return isSeries;
    }

    public void setIsSeries(Integer isSeries) {
        this.isSeries = isSeries;
    }

    /**
     * is_series，是否系列商品
     */
    private Integer isSeries;

    /**
     * 是否为多规格
     */
    private Boolean multiSku;

    /**
     * 版本号
     */
    private Long version;

    //当前针对兑吧商品，如果兑吧商品修改过，此值为1，否则0
    private Integer changedStatus;

    /**
     * grantOpTypeAppItem
     * @param opType
     */
    public void grantOpTypeAppItem(int opType){
        int v=1<<opType;
        operationsType=operationsType | v;
    }

    /**
     * ungrantOpTypeAppItem
     * @param opType
     */
    public void ungrantOpTypeAppItem(int opType){
        int v=1<<opType;
        v=~v;
        operationsType=operationsType & v;
    }

    /**
     * isOpTypeAppItem
     * @param opType
     * @return
     */
    public boolean isOpTypeAppItem(int opType){
        int v=1<<opType;
        int ret= operationsType & v;
        return ret!=0;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getBatchId() {
        return batchId;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Integer getMinFacePrice() {
        return minFacePrice;
    }

    public void setMinFacePrice(Integer minFacePrice) {
        this.minFacePrice = minFacePrice;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public String getCustomPrice() {
        return customPrice;
    }

    public void setCustomPrice(String customPrice) {
        this.customPrice = customPrice;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSubStatus() {
        return subStatus;
    }

    public void setSubStatus(String subStatus) {
        this.subStatus = subStatus;
    }

    public Boolean getHomeDisplay() {
        return homeDisplay;
    }

    public void setHomeDisplay(Boolean homeDisplay) {
        this.homeDisplay = homeDisplay;
    }

    public Boolean getOwner() {
        return isOwner;
    }

    public void setOwner(Boolean owner) {
        isOwner = owner;
    }

    public String getExchangeTipTemplate() {
        return exchangeTipTemplate;
    }

    public void setExchangeTipTemplate(String exchangeTipTemplate) {
        this.exchangeTipTemplate = exchangeTipTemplate;
    }

    public String getAlertMessage() {
        return alertMessage;
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getFacePrice() {
        return facePrice;
    }

    public void setFacePrice(Integer facePrice) {
        this.facePrice = facePrice;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public Integer getRemaining() {
        return remaining;
    }

    public void setRemaining(Integer remaining) {
        this.remaining = remaining;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getWhiteImage() {
        return whiteImage;
    }

    public void setWhiteImage(String whiteImage) {
        this.whiteImage = whiteImage;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getMultiImage() {
        return multiImage;
    }

    public void setMultiImage(String multiImage) {
        this.multiImage = multiImage;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceRelationId() {
        return sourceRelationId;
    }

    public void setSourceRelationId(Long sourceRelationId) {
        this.sourceRelationId = sourceRelationId;
    }

    public String getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope;
    }

    public Integer getOperationsType() {
        return operationsType;
    }

    public void setOperationsType(Integer operationsType) {
        this.operationsType = operationsType;
    }

    public String getLimitTimeBetween() {
        return limitTimeBetween;
    }

    public void setLimitTimeBetween(String limitTimeBetween) {
        this.limitTimeBetween = limitTimeBetween;
    }

    public Integer getLimitEverydayQuantity() {
        return limitEverydayQuantity;
    }

    public void setLimitEverydayQuantity(Integer limitEverydayQuantity) {
        this.limitEverydayQuantity = limitEverydayQuantity;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getLimitDate() {
        return limitDate;
    }

    public void setLimitDate(String limitDate) {
        this.limitDate = limitDate;
    }

    public String getCustomTag() {
        return customTag;
    }

    public void setCustomTag(String customTag) {
        this.customTag = customTag;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getVipLimits() {
        return vipLimits;
    }

    public void setVipLimits(Long vipLimits) {
        this.vipLimits = vipLimits;
    }

    public Integer getVipLimitType() {
        return vipLimitType;
    }

    public void setVipLimitType(Integer vipLimitType) {
        this.vipLimitType = vipLimitType;
    }

    public Date getAutoOffDate() {
        return autoOffDate;
    }

    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    public String getDevCustomCode() {
        return devCustomCode;
    }

    public void setDevCustomCode(String devCustomCode) {
        this.devCustomCode = devCustomCode;
    }

    public Long getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(Long salePrice) {
        this.salePrice = salePrice;
    }

    public String getExpressType() {
        return expressType;
    }

    public void setExpressType(String expressType) {
        this.expressType = expressType;
    }

    public Long getExpressPrice() {
        return expressPrice;
    }

    public void setExpressPrice(Long expressPrice) {
        this.expressPrice = expressPrice;
    }

    public Long getExpressTemplateId() {
        return expressTemplateId;
    }

    public void setExpressTemplateId(Long expressTemplateId) {
        this.expressTemplateId = expressTemplateId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Integer getClassifyPayload() {
        return classifyPayload;
    }

    public void setClassifyPayload(Integer classifyPayload) {
        this.classifyPayload = classifyPayload;
    }

    public String getImageJson() {
        return imageJson;
    }

    public void setImageJson(String imageJson) {
        this.imageJson = imageJson;
    }

    public String getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public Long getStockId() {
        return stockId;
    }

    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    public Boolean getMultiSku() {
        return multiSku;
    }

    public void setMultiSku(Boolean multiSku) {
        this.multiSku = multiSku;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Integer getChangedStatus() {
        return changedStatus;
    }

    public void setChangedStatus(Integer changedStatus) {
        this.changedStatus = changedStatus;
    }
}
