package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AmbExpressTemplateOptionDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 *
 * 加钱购商品运费模版选项service
 */
@AdvancedFeignClient
public interface RemoteAmbExpressTemplateOptionService {

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<AmbExpressTemplateOptionDto> find(Long id);

	/**
	 * 新增记录
	 * 
	 * @param entity
	 * @return
	 */
	public DubboResult<Long> insert(AmbExpressTemplateOptionDto entity);

	/**
	 * 更新记录
	 * 
	 * @param entity
	 */
	public DubboResult<Integer> update(AmbExpressTemplateOptionDto entity);

	/**
	 * 根据模版ID查询
	 * 
	 * @param expressTemplateId
	 * @return
	 */
	public DubboResult<List<AmbExpressTemplateOptionDto>> findByTemplateId(Long expressTemplateId);

	/**
	 * 根据模版ID集合批量查询
	 * 
	 * @param ids
	 * @return
	 */
	public DubboResult<List<AmbExpressTemplateOptionDto>> findByTemplateIds(List<Long> ids);

	/**
	 * 根据模版ID删除
	 * 
	 * @param expressTemplateId
	 * @return
	 */
	public DubboResult<Integer> deleteOptionByTemplateId(Long expressTemplateId);

	/**
	 * 添加模版选项
	 * 
	 * @param ambExpressTemplateOptionDOs
	 * @return
	 */
	public DubboResult<Integer> batchInsert(List<AmbExpressTemplateOptionDto> ambExpressTemplateOptionDOs);

}
