package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDescConfigDto;

import java.util.List;

/**
 * @Desc 商品图文描述后台管理service
 * @Author xuwei
 * @Date 2018/11/6
 */
@AdvancedFeignClient
public interface RemoteItemDescConfigService {
    /**
     * 根据自有商品id查询
     *
     * @param appItemId
     * @return
     */
    ItemDescConfigDto findByAppItemId(Long appItemId);

    /**
     * 根据兑吧商品id查询
     *
     * @param itemId
     * @return
     */
    ItemDescConfigDto findByItemId(Long itemId);

    /**
     * 插入
     *
     * @param itemDescConfig
     * @return
     */
    Long insert(ItemDescConfigDto itemDescConfig) throws BizException;

    /**
     * 更新
     *
     * @param itemDescConfig
     * @return
     */
    Integer update(ItemDescConfigDto itemDescConfig) throws BizException;

    /**
     * 批量查询
     * @param appItemIds
     * @return
     */
    List<ItemDescConfigDto> findByAppItemIds(List<Long> appItemIds);
}
