package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

/**
 * appitem extraInfo字段工具类
 * Created by sunyan on 2017/8/18.
 */
public class ExtraInfoUtils {

    public static final String BIZ_CREDITS="bizCredits";
    public static final String BUTTON_TEXT="buttonText";//兑换按钮文字（默认'马上兑换'）
    public static final String LABEL="label";//商品标签
    public static final String SECKILL_PHONE_LIMIT = "seckillLimit"; //是否开启秒杀充值电话号码限制

    private ExtraInfoUtils(){
        //do nothing
    }

    /**
     * 扩展积分
     * @param itemKeyDto
     * @return
     */
    public static String getBizCredits(ItemKeyDto itemKeyDto){
        if (itemKeyDto.getAppItem()!=null) {
            return getBizCredits(itemKeyDto.getAppItem().getExtraInfo());
        }
        return null;
    }

    /**
     * 扩展积分
     * @param extraInfo
     * @return
     */
    public static String getBizCredits(String extraInfo){
        if (StringUtils.isNotBlank(extraInfo)) {
            JSONObject json = JSONObject.parseObject(extraInfo);
            return json.getString(BIZ_CREDITS);
        }
        return null;
    }

    /**
     * 按key获取value
     * @param extraInfo
     * @return
     */
    public static String getValue(String extraInfo,String key){
        if (StringUtils.isNotBlank(extraInfo)) {
            JSONObject json = JSONObject.parseObject(extraInfo);
            return json.getString(key);
        }
        return null;
    }
}
