package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @Desc 开发者商品分页查询参数
 * @Author xuwei
 * @Date 2018/12/17
 */
public class AppItemPageQueries implements Serializable {
    private Long appId;
    //类型
    private String type;
    //子类型
    private Integer subType;
    //类型列表
    private List<String> types;
    //分组id
    private Long classifyId;
    //是否支持原价购买 ture：支持  false：不支持
    private Boolean originalPriceBuy;
    //是否自有  true：自有 false：分销
    private Boolean isOwner;
    //状态
    private String status;
    //商品名称
    private String title;
    //商品id列表
    private List<Long> ids;
    //过滤秒杀商品
    private Boolean exceptSeckill;
    //是否多规格 ture：多规格 false：无规格
    private Boolean multiSku;
    //运费类型 AppItemDto.ExpressTypeFree, AppItemDto.ExpressTypeUnity, AppItemDto.ExpressTypeTemplate
    private String expressType;
    //是否会员商品
    private Boolean vipGoods;
    //是否过滤老版本商品
    private Boolean filterOldVersion;

    private int pageSize;
    private int pageNo;
    private int offset = -1;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = StringUtils.isBlank(type) ? null : type;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public List<String> getTypes() {
        return types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Boolean getOriginalPriceBuy() {
        return originalPriceBuy;
    }

    public void setOriginalPriceBuy(Boolean originalPriceBuy) {
        this.originalPriceBuy = originalPriceBuy;
    }

    public Boolean getIsOwner() {
        return isOwner;
    }

    public void setIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = StringUtils.isBlank(status) ? null : status;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = StringUtils.isBlank(title) ? null : title;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public List<Long> getIds() {
        return CollectionUtils.isEmpty(ids) ? null : ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = CollectionUtils.isEmpty(ids) ? null : ids;
    }

    public Boolean getExceptSeckill() {
        return exceptSeckill;
    }

    public void setExceptSeckill(Boolean exceptSeckill) {
        this.exceptSeckill = exceptSeckill;
    }

    public Boolean getMultiSku() {
        return multiSku;
    }

    public void setMultiSku(Boolean multiSku) {
        this.multiSku = multiSku;
    }

    public String getExpressType() {
        return expressType;
    }

    public void setExpressType(String expressType) {
        this.expressType = StringUtils.isBlank(expressType) ? null : expressType;
    }

    public Boolean getVipGoods() {
        return vipGoods;
    }

    public void setVipGoods(Boolean vipGoods) {
        this.vipGoods = vipGoods;
    }

    public Boolean getFilterOldVersion() {
        return filterOldVersion;
    }

    public void setFilterOldVersion(Boolean filterOldVersion) {
        this.filterOldVersion = filterOldVersion;
    }

    public int getOffset() {
        if (offset == -1) {
            offset = pageSize * (pageNo - 1);
        }
        return offset;
    }
}
