package cn.com.duiba.goods.center.api.remoteservice.enums;


import java.util.Objects;

/**
 * @program: goods-center
 * @description: 权益兑换状态枚举
 * @author: Simba
 * @create: 2019-07-10 10:27
 **/
public enum EquityExchangeStatusEnum {

    ALL(0, "全部"),
    NOT_ACTIVE(1, "未生效"),
    ACTIVE(2, "已生效"),
    INVALID(3, "已失效"),
    VERIFICATION(4, "已核销"),
    ;
    private Integer code;
    private String desc;

    EquityExchangeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static EquityExchangeStatusEnum ofValue(Integer code) {
        for (EquityExchangeStatusEnum exchangeStatusEnum : values()) {
            if (Objects.equals(exchangeStatusEnum.getCode(), code)) {
                return exchangeStatusEnum;
            }
        }
        return null;
    }
}

