/**
 * Project Name:goods-center-api
 * File RemoteGoodsBatchService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年6月30日下午5:43:43
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
 */

package cn.com.duiba.goods.center.api.remoteservice.front;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.api.enums.GoodsTypeEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodCouponRetrieveLogDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * ClassName:RemoteGoodsBatchService <br/>
 * Function: 商品批次服务. <br/>
 * Date: 2016年8月01日 下午5:43:43 <br/>
 * 
 * @author zhengjy
 * @version
 * @since JDK 1.6
 * @see
 */
@AdvancedFeignClient
public interface RemoteGoodsBatchService {

	/**
	 * 查询多个商品批次<br/>
	 *
	 * @author xuhengfei
	 * @param gtype
	 *            商品类型
	 * @param gids
	 *            商品id
	 * @return 结果Map对象, gid --> List<GoodsBatchDto>
	 * @since JDK 1.6
	 */
	@Deprecated
	DubboResult<Map<Long, List<GoodsBatchDto>>> findGoodsBatchs(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype, List<Long> gids);

	/**
	 * 查询多个商品批次<br/>
	 *
	 * @author xuhengfei
	 * @param gtype
	 *            商品类型
	 * @param gids
	 *            商品id
	 * @return 结果Map对象
	 * @since JDK 1.6
	 */
	DubboResult<Map<Long, List<GoodsBatchDto>>> findGoodsBatchsApi(GoodsTypeEnum gtype, List<Long> gids);

	/**
	 * 查询商品的所有可用批次<br/>
	 *
	 * @author xuhengfei
	 * @param gtype
	 *            商品类型
	 * @param gid
	 *            商品id
	 * @return 结果集
	 * @since JDK 1.6
	 */
	@Deprecated
	DubboResult<List<GoodsBatchDto>> findGoodsBatch(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype, Long gid);

	/**
	 * 查询商品的所有可用批次<br/>
	 *
	 * @author xuhengfei
	 * @param gtype
	 *            商品类型
	 * @param gid
	 *            商品id
	 * @return 结果集
	 * @since JDK 1.6
	 */
	DubboResult<List<GoodsBatchDto>> findGoodsBatchApi(GoodsTypeEnum gtype, Long gid);
	
	/**
	 * 查询商品的所有可用批次
	 * 
	 * @param gtype
	 * @param gid
	 * @return
	 */
	@Deprecated
	DubboResult<List<GoodsBatchDto>> findGoodsBatchNow(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype, Long gid);

	/**
	 * 查询商品的所有可用批次
	 *
	 * @param gtype
	 * @param gid
	 * @return
	 */
	DubboResult<List<GoodsBatchDto>> findGoodsBatchNowApi(GoodsTypeEnum gtype, Long gid);

	/**
	 * 回收某个优惠券某个批次的券码
	 * @param gtype
	 * @param gid
	 * @param batchId
	 * @param dstQuantity
	 * @return
	 */
	@Deprecated
	DubboResult<Long> retrieveGoodsBatch(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype, Long gid, Long batchId, Long dstQuantity);

	/**
	 * 回收某个优惠券某个批次的券码
	 * @param gtype
	 * @param gid
	 * @param batchId
	 * @param dstQuantity
	 * @return
	 */
	DubboResult<Long> retrieveGoodsBatchApi(GoodsTypeEnum gtype, Long gid, Long batchId, Long dstQuantity);

	/**
	 * 查询回收结果
	 * 
	 * @param id
	 * @return
	 */
	DubboResult<GoodCouponRetrieveLogDto> queryRetrieveRet(Long id);

	/**
	 * 查询特定日期的批次
	 *
	 * @param gtype
	 * @param gid
	 * @param startDay
	 * @param endDay
	 * @return
	 */
	Long findBatchIdByStartDayAndDay(GoodsTypeEnum gtype, Long gid, Date startDay, Date endDay);

	Map<Long, List<GoodsBatchDto>> findGoodsBatchsNotDeleted(GoodsTypeEnum gtype,List<Long> gids) throws BizException;
}
