package cn.com.duiba.goods.center.api.remoteservice.sku;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AttributeLibraryDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAttributeLibraryService {
    List<AttributeLibraryDto> findAllAttributeLibrary();

    List<AttributeLibraryDto> findAttributeLibraryByIdList(List<Long> idList);

    /**
     * 查询指定app的规格列表
     *
     * @param appId
     * @return
     */
    List<AttributeLibraryDto> findAttributeLibraryByAppId(Long appId);

    /**
     * 保存规格
     *
     * @param attributeLibraryDto
     * @return
     */
    Long saveAttributeLibrary(AttributeLibraryDto attributeLibraryDto) throws BizException;
}
