package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.SupplierProductDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import javax.annotation.CheckForNull;
import java.util.List;

/**
 * Created by xiaoxuda on 2017/10/09
 */
@AdvancedFeignClient
public interface RemoteSupplierProductService {
	/**
	 * 获取上游产品
	 * @param supplier
	 * @return
     */
	DubboResult<SupplierProductDto> findBySupplier(String supplier);

	/**
	 * 获取上游产品列表
	 * @param supplier
	 * @return
     */
	DubboResult<List<SupplierProductDto>> findAllBySupplier(String supplier);

	/**
	 * 根据上游名称和商品ID查询上游价格
	 * @param supplier
	 * @param productId
     * @return
     */
	DubboResult<SupplierProductDto> findBySupplierAndProductId(String supplier, String productId);

	/**
	 * @param supplier
	 * @param facePrice
     * @return
     */
	DubboResult<List<SupplierProductDto>> findBySupplierAndFacePrice(String supplier, Integer facePrice);

	/**
	 * 根据供应商名称和网络运营商名称查询产品
	 * @param supplier
	 * @param mobile
	 * @return
	 */
	DubboResult<List<SupplierProductDto>> findBySupplierAndMobile(String supplier, String mobile);


	/**
	 * @param supplier
	 * @param mobile
	 * @param province
     * @return
     */
	DubboResult<List<SupplierProductDto>> findBySupplierAndMobileAndProvince(String supplier, String mobile, String province);

	/**
	 *
	 * @param supplier
	 * @return
     */
	DubboResult<List<SupplierProductDto>> findAllBySupplierOrderByNameAndFacePrice(String supplier);

	/**
	 *
	 * @param supplier
	 * @return
     */
	DubboResult<List<SupplierProductDto>> findAllBySupplierOrderByProvinceAndFacePrice(String supplier);

	/**
	 *
	 * @param supplier
	 * @param gameId
     * @return
     */
	DubboResult<List<SupplierProductDto>> findAllBySupplierAndGameId(String supplier, String gameId);

	/**
	 *
	 * @param ids
	 * @return
     */
	DubboResult<List<SupplierProductDto>> findAllByIds(List<Long> ids);

	/**
	 *
	 * @param supplierProductDO
     */
	DubboResult<Long> insert(SupplierProductDto supplierProductDO);

	/**
	 *
	 * @param supplierProductDO
     */
	DubboResult<Integer> update(SupplierProductDto supplierProductDO);

	/**
	 *
	 * @param id
	 * @return
     */
	DubboResult<SupplierProductDto> find(Long id);

	/**
	 * 根据供应商编码，产品id，运营商查询产品
	 * @param supplier
	 * @param productId
	 * @param mobile 运营商名称，不包含“中国”两个字
	 * @return
	 */
	DubboResult<SupplierProductDto> findBySupplierAndProductIdAndMobile(String supplier, String productId, String mobile);

	/**
	 * 查询浦上话费供应产品
	 * 会根据appId区分是否含税
	 * @param appId
	 * @param facePrice
	 * @return
	 */
	@CheckForNull
	SupplierProductDto findPuupPhoneBillProductByAppIdAndFacePriceAndMobile(Long appId, Integer facePrice, String mobile);

	/**
	 * 获取浦上话费费率 用于开发者后台展示
	 * 会根据appId区分是否含税
	 * @param appId
	 * @return
	 */
	List<String> findPuupPhoneBillRate(Long appId);
}
