package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.ElasticGiftsItemShowDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;

/**
 * 兑吧商品相关服务
 * 
 * @author houwen
 */
@AdvancedFeignClient
public interface RemoteDuibaItemGoodsService {

	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<ItemDto> find(Long id);

	/**
	 * 根据ID集合查询应用商品信息
	 * 
	 * @param ids
	 * @return
	 */
	public DubboResult<List<ItemDto>> findByIds(List<Long> ids);

	List<ItemDto> findSimpleByIds(List<Long> ids) throws BizException;

	/**
	 * ************************************************
	 * 注：用于老的商品结构，禁止新的商品结构调用此方法, 会强制set version为0
	 * ************************************************
	 *
	 * 创建商品
	 * @param itemDto
	 * @return
	 */
	public DubboResult<Long> insert(ItemDto itemDto);

	/**
	 * ************************************************
	 * 注：用于老的商品结构，禁止新的商品结构调用此方法, 会强制set version为0
	 * ************************************************
	 *
	 * 修改商品
	 * @param itemDto
	 * @return
	 */
	public DubboResult<Boolean> update(ItemDto itemDto);

	/**
	 * 删除商品，不推荐使用，替代方法RemoteDuibaItemGoodsBackendService.deleteAll
	 * @param itemId
	 * @return
	 */
	@Deprecated
	public DubboResult<Boolean> delete(Long itemId);

	/**
	 * 修改启用禁用
	 * 
	 * @param itemId
	 * @param enable
	 * @return
	 */
	public DubboResult<Boolean> updateEnable(Long itemId, Boolean enable);

	/**
	 * 编辑商品，增加库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> appendStock(Long itemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> deductStock(Long itemId, Long number);

	/**
	 * 查询兑吧自动推荐商品
	 * 
	 * @param appId
	 * @return
	 */
	public DubboResult<List<ItemDto>> findAutoRecommend(Long appId);

	/**
	 * 查询兑吧自动推荐
	 * 
	 * @param appId
	 * @return
	 */
	@RequestMapping("findAutoRecommendItemKeyByAppId")
	public DubboResult<List<ItemKeyDto>> findAutoRecommendItemKey(Long appId);

	/**
	 * 查询兑吧自动推荐
	 * 
	 * @param appId
	 * @param size
	 * @param query
	 * @return
	 */
	public DubboResult<List<ItemKeyDto>> findAutoRecommendItemKey(Long appId, Integer size, Map<String, Object> query);
	
	/**
	 * 根据类型查询一个，一般用于直冲类
	 * @param type
	 * @return
	 */
	public DubboResult<ItemDto> findByType(String type);

    DubboResult<ItemDto> findByTypeAndActualPrice(String type, Integer actualPrice);

    /**
	 * 查询JSONVALUE
	 * @param id
	 * @param key
	 * @return
	 */
	public DubboResult<String> getJsonValue(Long id, String key);
	
	/**
	 * 设置JSONVALUE
	 * @param id
	 * @param key
	 * @param value
	 * @return
	 */
	public DubboResult<Integer> setJsonValue(Long id, String key, String value);
	
    /**
     * 根据礼包项的 itemIds,获取对应的兑换项 s
     * 包含用户兑换记录的筛选
     * @param itemIds
     * @param appId
     * @param consumerId
     * @return
     */
    DubboResult<List<ElasticGiftsItemShowDto>> getItemsByElItemIds4Mobile(List<Long> itemIds, Long appId, Long consumerId);

    /**
     * 检查弹层活动兑换项权限
     * @param itemId
     * @param appId
     * @param consumerId
     * @return
     */
    DubboResult<Boolean> checkElasticTakeOrder(Long itemId, Long appId, Long consumerId);

	public DubboResult<ItemDto> findBySourceRelationIdAndSourceType(Long sourceRelationId, Integer sourceType);

	/**
	 * ************************************************
	 * 注：用于新的商品结构，老的商品结构不要调此方法
	 * ************************************************
	 *
	 * 此方法 version为null, version会设置为1
	 * @param itemDto
	 * @return
	 */
	Long insertNew(ItemDto itemDto) throws BizException;

	/**
	 * ************************************************
	 * 注：用于新的商品结构， 老的商品结构不要调此方法
	 * ************************************************
	 *
	 * 此方法 version为null, version会设置为1
	 * @param itemDto
	 * @return
	 */
	Boolean updateNew(ItemDto itemDto) throws BizException;
}
