package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * itemKey Dto
 */
public class ItemKeyDto implements Serializable {

	private static final long serialVersionUID = 284762871342171085L;

	protected AppItemDto appItem;

	protected ItemDto item;

	protected Long appId;

	public ItemKeyDto() {

	}

	/**
	 * ItemKeyDto
	 * @param appItemDto
	 * @param itemDto
	 * @param appId
	 */
	public ItemKeyDto(AppItemDto appItemDto, ItemDto itemDto, Long appId) {
		this.appItem = appItemDto;
		this.item = itemDto;
		this.appId = appId;
	}

	/**
	 * ItemKeyDto
	 * @param appItem
	 * @param item
	 */
	public ItemKeyDto(AppItemDto appItem, ItemDto item) {
		this.appItem = appItem;
		this.item = item;
	}

	public AppItemDto getAppItem() {
		return appItem;
	}

	public void setAppItem(AppItemDto appItem) {
		this.appItem = appItem;
	}

	public ItemDto getItem() {
		return item;
	}

	public void setItem(ItemDto item) {
		this.item = item;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	/**
	 * getItemDtoType
	 * @return
	 */
	public String getItemDtoType() {
		String appItemType = this.getAppItem() != null ? this.getAppItem().getType() : null;
		return this.getItem() != null ? this.getItem().getType() : appItemType;
	}

	/**
	 * isValid
	 * @return
	 */
	public boolean isValid() {
		return this.getItem() != null || this.getAppItem() != null;
	}

	/**
	 * isItemMode
	 * @return
	 */
	public boolean isItemMode() {
		return this.getItem() != null && this.getAppItem() == null;
	}

	/**
	 * isSelfAppItemMode
	 * @return
	 */
	public boolean isSelfAppItemMode() {
		return this.getItem() == null && this.getAppItem() != null;
	}

	/**
	 * isDuibaAppItemMode
	 * @return
	 */
	public boolean isDuibaAppItemMode() {
		return this.getItem() != null && this.getAppItem() != null;
	}

	/**
	 * isAmbItemKey
	 * @return
	 */
	public Boolean isAmbItemKey() {
		boolean result = this.isSelfAppItemMode() ? this.getAppItem().isOpTypeAppItem(ItemDto.OpTypeIsAmb) : this.getItem().isOpTypeItem(ItemDto.OpTypeIsAmb);
		return this.isDuibaAppItemMode() ? Boolean.FALSE : result;
	}

	/**
	 * isAutoOff
	 * @return
	 */
	public boolean isAutoOff() {
		boolean itemAutoOff = false;
		Date today = new Date();
		if (this.getItem() != null && this.getItem().getAutoOffDate() != null) {
			itemAutoOff = this.getItem().getAutoOffDate().before(today);
		}

		boolean appItemAutoOff = false;
		if (this.getAppItem() != null && this.getAppItem().getAutoOffDate() != null) {
			appItemAutoOff = this.getAppItem().getAutoOffDate().before(today);
		}

		return itemAutoOff && appItemAutoOff;
	}

	public String getItemType() {
		if (getItem() != null) {
			return getItem().getType();
		}
		if (getAppItem() != null) {
			return getAppItem().getType();
		}
		return null;
	}

	/**
	 * 判断是否是开发者秒杀商品
	 * @return
     */
	public boolean isDevSecSkill(){
		if(this.appItem==null){
			return false;
		}
		if(!this.appItem.isOpTypeAppItem(ItemDto.OpTypeTimeLimit)){
			return false;
		}

		//话费的创建时间一般都很久，一般小于2018-01-18，所以不能根据创建时间去判断
		//因此根据修改时间去判定，暂定是2018-09-25 11:30:00
		if(ItemDto.TypePhonebillDingzhi.equals(this.appItem.getType()) && this.appItem.getGmtModified().getTime() > 1537846200000L){
			return true;
		}

		return this.appItem.getGmtCreate().getTime()>1516244400000L;//2018-01-18 11:00:00
	}

	/**
	 * 判断是否是重构商品
	 * @return
	 */
	public boolean isV1(){
		String type = this.getItemDtoType();
		if(!ItemDto.TypeObject.equals(type) && !ItemDto.TypeCoupon.equals(type) && !ItemDto.TypeVirtual.equals(type)){
			return false;
		}
		if(this.getAppItem()!=null && this.getAppItem().getVersion() != null && this.getAppItem().getVersion().intValue() == 1){
			return true;
		}

		if(this.getItem()!=null && this.getItem().getVersion() != null && this.getItem().getVersion().intValue() == 1){
			return true;
		}

		return false;
	}

	/**
	 * 是否卡密
	 * @return
     */
	public boolean isCryptoCard(){
        if (!ItemDto.TypeCoupon.equals(this.getItemDtoType())) {
			return false;
		}
		if(this.getAppItem()!=null && this.getAppItem().getSubType() != null && this.getAppItem().getSubType().intValue() == ItemDto.SubTypeCryptoCard){
			return true;
		}

		if(this.getItem()!=null && this.getItem().getSubType() != null && this.getItem().getSubType().intValue() == ItemDto.SubTypeCryptoCard){
			return true;
		}
		return false;
	}

    /**
     * 是否老sku商品
     *
     * @return
     */
    public boolean isSeries() {
        return getAppItem() != null && Objects.equals(getAppItem().getIsSeries(), 1);
    }

//	/**
//	 * 判断item是否是重构商品
//	 * @return
//	 */
//	public Boolean isV14Item(){
//		if(this.getItem() == null){
//			return null;
//		}
//
//		if(this.getItem().getVersion() == null || this.getItem().getVersion().intValue() != 1){
//			return false;
//		}
//
//		return true;
//	}
//
//	/**
//	 * 判断appItem是否是重构商品
//	 * @return
//	 */
//	public Boolean isV14AppItem(){
//		if(this.getAppItem() == null){
//			return null;
//		}
//
//		if(this.getAppItem().getVersion() == null || this.getAppItem().getVersion().intValue() != 1){
//			return false;
//		}
//
//		return true;
//	}
}
