package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * Created by sunyan on 2019/1/18.
 */
public enum AppItemLockBizTypeEnum {
    SECKILL(1, "新秒杀活动");


    private int type;

    private String desc;

    AppItemLockBizTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }


    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 根据类型，反查枚举类<br/>
     * 若是没找到，返回null
     *
     * @param type 枚举类型
     * @return 枚举类
     */
    public static AppItemLockBizTypeEnum getAppItemLockBizTypeEnum(int type) {

        AppItemLockBizTypeEnum[] values = AppItemLockBizTypeEnum.values();
        for (AppItemLockBizTypeEnum value : values) {
            if (value.getType() == type) {
                return value;
            }
        }
        return null;
    }
}
