package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.param.AppItemSkuRemainingParam;
import cn.com.duiba.goods.center.api.remoteservice.param.SupplyItemQueryParam;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * 开发者商品相关服务
 * 
 * @author houwen
 */
@AdvancedFeignClient
public interface RemoteAppItemGoodsService {

	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<AppItemDto> find(Long id);
	
	/**
	 * 根据APPid和兑吧商品ID查询开发者商品
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public DubboResult<AppItemDto> findByAppAndItem(Long appId, Long itemId);

	/**
	 * 根据APPid和兑吧商品IDs查询开发者商品
	 * @param appId
	 * @param itemIds
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findByAppAndItems(Long appId, List<Long> itemIds);

	/**
	 * 根据APPid和兑吧商品ID查询开发者商品上架的
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public DubboResult<AppItemDto> findByAppAndItemOnline(Long appId, Long itemId);
	
	/**
	 * 获取banner对应商品项(缓存,缺省字段)
	 * 
	 * @param appId
	 * @param appItems
	 * @return
	 */
    public DubboResult<List<AppItemDto>> findBannerIconAppItemByCache(Long appId,List<Long> appItems);

	/**
	 * 根据ID集合查询应用商品信息
	 *
	 * @param ids
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findByIds(List<Long> ids);
	
	/**
	 * 根据RelationId批量查询AppItemId
	 * @return
	 */
	public DubboResult<List<Long>> findIDbySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes);

	/**
	 * findBySourceIdsAndSourceTypes
	 * @param sourceIds
	 * @param sourceTypes
	 * @param appId
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId);

	/**
	 * 手机端分页查询商品
	 * @param appId
	 * @param queryParams
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findByLimitCache(Long appId, Map<String, Object> queryParams);
	
	/**
	 * 查询APP商品最大的排序
	 * @param appId
	 * @return
	 */
	public DubboResult<Integer> findAppMaxPayload(Long appId);
	
	/**
	 * 创建商品
	 * 
	 * @param appItemDto
	 * @return
	 */
	public DubboResult<Long> insert(AppItemDto appItemDto);

	/**
	 * 修改商品
	 * 
	 * @param appItemDto
	 * @return
	 */	
	public DubboResult<Boolean> update(AppItemDto appItemDto);

	/**
	 * 删除商品
	 * 执行玩删除后需要调用： DuibaEventsDispatcher.get().dispatchEvent(new ItemEvent(ItemEvent.ItemEventType.onDeleted, key));
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	public DubboResult<Boolean> delete(Long appId, Long appItemId);

	/**
	 * 批量删除商品
	 * 
	 * @param appId
	 * @param appItemIds
	 * @return
	 */
	public DubboResult<Integer> deleteByIds(Long appId, List<Long> appItemIds);

	/**
	 * 修改状态
	 * 
	 * @param appId
	 * @param appItemId
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public DubboResult<Boolean> updateStatus(Long appId, Long appItemId, String status);

	/**
	 * 批量修改状态
	 * 
	 * @param appId
	 * @param appItemIds
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public DubboResult<Integer> updateStatusByIds(Long appId, List<Long> appItemIds, String status);

	/**
	 * 编辑商品，增加库存
	 * @param appId
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> appendStock(Long appId, Long appItemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * @param appId
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> deductStock(Long appId, Long appItemId, Long number);

	/**
	 * 根据releationID批量修改状态
	 * @param status
	 * @param delete
	 * @param oids
	 * @return
	 */
    public DubboResult<Integer> updateStatusByActivityIds(String status, Boolean delete, List<Long> oids);

	/**
	 * 根据活动ID更新状态
	 */
	public DubboResult<Integer> updateStatusByActivityId(String status, Boolean delete, List<Long> relationIds);

	/**
	 * 批量修改商品
	 * 最多支持一次批量更新50条, else 抛出异常提示
	 * @param appItemDtos
	 * @return
	 */
	DubboResult<Boolean> updateItems(List<AppItemDto> appItemDtos);

	/**
	 * 根据app_id、type、source_relation_id、source_type批量修改积分价值
	 * @param appItemDtos
	 * @return
	 */
	void batchUpdateItemByAppIdAndTypeAndSourceRelationId(List<AppItemDto> appItemDtos);

	/**
	 * 根据app_id、type、source_relation_id、source_type修改积分价值
	 * @param appItemDto
	 * @return
	 */
	void updateItemByAppIdAndTypeAndSourceRelationId(AppItemDto appItemDto);

	/**
	 * 查询商品库存信息
	 *
	 * @param ids
	 * @return
	 * @throws BizException
	 */
	Map<Long, Integer> findRemainingByIds(List<Long> ids);

	/**
	 * 根据appItem列查询所有sku维度的库存,会根据appId过滤非当前app的商品
	 * 新商品返回sku维度的库存
	 * 老商品会构建一个skuId为零的返回对象
	 * @param appItemIds
	 * @param appId
	 * @return
	 */
	List<AppItemSkuRemainingParam> findRemainingByAppItemIdsAndAppId(List<Long> appItemIds, Long appId);

	/**
	 * 分页查询当前app有效的采购商品，返回appItemId列表
	 * 1.兑吧商品，过滤京东供应商提供的商品
	 * 2.上架
	 * 3.未删除
	 * 4.实物或优惠券
	 * 5.按照商品入库时间 进行倒序排列
	 */
	Page<Long> findValidIdsForSupply(SupplyItemQueryParam param);
}
