package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.SellerDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by zhengjy on 11/05/2016 
 */
@AdvancedFeignClient
public interface RemoteSellerService {
	/**
     * 新增商家安全签名
     * @param sellerDto
     * @return boolean true:成功，false：失败
     */
    public DubboResult<Boolean> insertSeller(SellerDto sellerDto);
  
  
    /**
     * 删除商家安全签名
     * @param id
     * @return Boolean
     *      true:成功，false：失败
     */
    public DubboResult<Boolean> deleteSeller(Long id);
     
    /**
     *
     * @param sellerDto
     *      offset 开始值
     *      max 每页数量
     * @return
     *      List<SellerDto> 商家安全签名列表
     * @return
     */
    public DubboResult<List<SellerDto>> findAll(SellerDto sellerDto, Integer offset, Integer max);
  
    /**
      *查询总数
      *@param sellerDto
      *@return
      *    Integer 总数
      */
    public DubboResult<Integer> findCount(SellerDto sellerDto);
     
    /**
     *
     * @param id
     * @return sellerSafeSignDto
     */
    public DubboResult<SellerDto> findById(Long id);
}
