package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * Created by xutao on 2018/11/29.
 */
public class ItemBaseQueries implements Serializable {
    private static final long serialVersionUID = -253695036518182445L;
    private boolean OFFSET_DESC = Boolean.FALSE;
    private boolean OFFSET_LIMIT =Boolean.FALSE;
    private boolean OFFSET_SKU = Boolean.FALSE;
    private boolean OFFSET_MEMO = Boolean.FALSE;
    private boolean OFFSET_TOTAL_STOCK = Boolean.FALSE;

    public ItemBaseQueries() {
        //do nothing
    }

    private ItemBaseQueries(boolean all, boolean totalStock) {
        if (all) {
            withDescConfig();
            withLimitConfig();
            withSku();
            withMemo();
        }

        if(totalStock){
            withTotalStock();
        }
    }

    public static ItemBaseQueries empty() {
        return new ItemBaseQueries();
    }

    public static ItemBaseQueries all() {
        return new ItemBaseQueries(Boolean.TRUE, Boolean.TRUE);
    }

    public static ItemBaseQueries allWithoutTotalStock() {
        return new ItemBaseQueries(Boolean.TRUE, Boolean.FALSE);
    }

    public ItemBaseQueries withDescConfig() {
        OFFSET_DESC = Boolean.TRUE;
        return this;
    }

    public ItemBaseQueries withLimitConfig() {
        OFFSET_LIMIT = Boolean.TRUE;
        return this;
    }

    public ItemBaseQueries withSku() {
        OFFSET_SKU = Boolean.TRUE;
        return this;
    }

    public ItemBaseQueries withMemo() {
        OFFSET_MEMO = Boolean.TRUE;
        return this;
    }

    public ItemBaseQueries withTotalStock() {
        OFFSET_TOTAL_STOCK = Boolean.TRUE;
        return this;
    }

    public boolean hasDescConfig() {
        return OFFSET_DESC;
    }

    public boolean hasLimitConfig() {
        return OFFSET_LIMIT;
    }

    public boolean hasSku() {
        return OFFSET_SKU;
    }

    public boolean hasMemo() {
        return OFFSET_MEMO;
    }

    public boolean hasTotalStock(){
        return OFFSET_TOTAL_STOCK;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
