package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * 兑吧虚拟商品子类型枚举
 *
 * 只有当商品时虚拟商品时子类型才生效
 * @see cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto#subType
 * @author zhangruofan
 * @date 2019/02/02
 */
public enum VirtualSubType {
    /**
     * 支付宝转账
     */
    ALI_PAY(10, "通过支付宝用户id转账"),

    /**
     * 月补签卡
     */
    RESIGN_MONTH_CARD(11, "月补签卡"),
    /**
     * 衢州招行活动专用充值商品
     */
    QZZH_DUIBA_VIRTUAL(12, " 衢州招行活动专用商家自充"),

    /**
     * 多张集卡
     */
    COLLECT_CARDS(13, "多张集卡"),
    /**
     * 江西农行话费
     */
    JXABC_DUIBA_VIRTUAL(14, "江西农行话费"),
    /**
     * oppo微信红包定制
     * */
    OPPO_WECHAT_REDPACK_DUIBA_VIRTUAL(15, "oppo微信红包"),
    /**
     * 浙江中行话费
     */
    ZHEJIANG_ZHONGHANG_DUIBA_VIRTUAL(16,"浙江中行话费"),

    /**
     * 苏州招行-八维通优惠券
     */
    BWT_COUPON_DUIBA_VIRTUAL(17,"苏州招行八维通优惠券"),
    /**
     * 南京中信话费虚拟商品
     */
    NJZX_DUIBA_VIRTUAL(18,"南京中信话费虚拟商品"),
    ;

    private Integer code;
    private String desc;

    VirtualSubType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
