package cn.com.duiba.goods.center.api.remoteservice.sku;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AppItemSkuAtrributeDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AppItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.RedefineAttributeDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.RedefineSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.SkuDto;

import java.util.List;
import java.util.Map;


@AdvancedFeignClient
public interface RemoteAppItemSkuService {
    /**
     * 根据开发者商品id，查询sku信息
     */
    List<AppItemSkuDto> findSkuListByAppItemId(Long appItemSkuId);

    /**
     * 根据开发者商品id列表，查询sku信息
     */
    List<AppItemSkuDto> findSkuByItemIdList(List<Long> appItemIds);

    Integer saveSku(AppItemSkuDto appItemSkuDto);

    Integer batchSaveSku(List<AppItemSkuDto> appItemSkuDtoList);

    Integer deleteSkuByAppItemId(Long appItemId);

    List<String> reBuildSkuInfo(String extraString);

    List<RedefineSkuDto> getSkuList(List<AppItemSkuDto> skuList);

    List<RedefineAttributeDto> getAttribute(List<AppItemSkuDto> skuList);

    /**
     * 根据skuId集合中的AttributeJson 解析出属性名称，及属性值信息
     * @param attributeJsons
     * @return
     */
    List<RedefineAttributeDto> getAttributeByAttributeJson(List<String> attributeJsons);

    /**
     * 根据skuId集合返回sku的属性信息
     * 返回格式为 白色/XL
     * @param skuIdList
     * @return
     */
    List<RedefineSkuDto> findSkuRedefineValue(List<Long> skuIdList);

    /**
     * 根据skuId集合返回sku的属性信息
     * 返回格式为
     * @param skuIdList
     * @return
     */
    List<SkuDto> findSkuNameAndValue(List<Long> skuIdList);

    /**
     * 批量更新统一商品下的sku
     *
     * @param appItemId
     * @param appItemSkuDtoList
     * @param isNew 是否新建
     * @return
     * @throws BizException
     */
    int batchUpdateSkuByAppItemId(Long appItemId, List<AppItemSkuDto> appItemSkuDtoList, Integer creditsRate, boolean isNew) throws BizException;

    /**
     * 更新优惠券的sku
     *
     * @param appItemId
     * @param appItemSkuDtoList
     * @param isNew 是否新建
     * @return map cardLibraryId:skuId
     * @throws BizException
     */
    Map<Long, Long> batchUpdateCouponSkuByAppItemId(Long appItemId, List<AppItemSkuDto> appItemSkuDtoList, Integer creditsRate, boolean isNew) throws BizException;

    /**
     * 根据id查询
     *
     * @param skuId
     * @return
     */
    AppItemSkuDto findSkuById(Long skuId);

    /**
     * 根据id查询
     *
     * @param skuId
     * @return
     */
    AppItemSkuDto findSkuByIdIncludeDeleted(Long skuId);

    /**
     * 更具sku获取商品展示用sku value名字   例子（36;黄色;旗舰版）
     * @param attributeJson
     * @return
     */
    String findSkuShowName(String attributeJson);

    /**
     * 根据appItemSkuId查询sku信息（包含库存）
     * @param appItemSkuIds
     * @return
     */
    List<AppItemSkuDto> findSkuByIdListWithStock(List<Long> appItemSkuIds);

    List<AppItemSkuDto> findSkuByIdListWithoutStock(List<Long> appItemSkuIds);

    /**
     * 根据appItemSkuId查询sku信息（包含库存）（包含已删除sku）
     *
     * @param appItemSkuIds
     * @return
     */
    List<AppItemSkuDto> findAllSkuListWithStock(List<Long> appItemSkuIds);

    /**
     * 根据skuIds 查询appItemSku List
     * @param skuIds
     * @return
     */
    List<AppItemSkuAtrributeDto> findSkuListBySkuIds(List<Long> skuIds);

    /**
     * 查询SKU库存
     * 该方法不适用于优惠券的查询
     * @param skuId
     * @return
     */
    Long findStock(Long skuId);

    /**
     * 根据商品编码 和 itemIds 筛选商品列表
     * @param specNo
     * @param ids
     * @return
     */
    List<AppItemSkuDto> listSkuMerchantCodingAndAppItemIds(String specNo,List<Long> ids);
}
