package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.api.bo.KeyValueDto;
import cn.com.duiba.api.bo.KeyValueEntity;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemNewExtraDto;

import java.util.List;

/**
 *
 * 商品新拓展信息接口
 * 增加app item的接口请加appItem
 * Created by hww on 2018/4/25 下午8:20.
 */
@AdvancedFeignClient
public interface RemoteItemNewExtraService {

    /**
     * 单独find item extra,注意不是app item extra
     * @param itemId
     * @return
     */
    ItemNewExtraDto findItemNewExtra(Long itemId);

    /**
     * 批量insert Item extra
     * @param itemId
     * @return
     */
    int updateOrInsertBatchApi(Long itemId, List<KeyValueDto> kvs);

    /**
     * 批量insert appitem extra
     *
     * @param appItemId
     * @return
     */
    int updateOrInsertBatchAppItemExtra(Long appItemId, List<KeyValueDto> kvs);

    int updateOrInsertAppItemExtraApi(Long appItemId, KeyValueDto kvs);

    /**
     * 单独insert Item extra
     * @param itemId
     * @return
     */
    int updateOrInsertOne(Long itemId, String propName, String propValue);

    /**
     * 单独删除Item extra
     * @param itemId
     * @return
     */
    int deleteOneValue(Long itemId, String propName);

    /**
     * 删除Item extra
     * @param itemId
     * @return
     */
    boolean deleteByItemId(Long itemId);

    /**
     * 批量insert appItem请使用insertAppItemBatch
     * @param appItemId
     * @param kvs
     * @return
     */
    @Deprecated
    int insertBatchApi(Long appItemId, List<KeyValueDto> kvs);

    /**
     * 批量insert appItem
     * @param appItemId
     * @param kvs
     * @return
     */
    int insertAppItemBatchApi(Long appItemId, List<KeyValueDto> kvs);

    /**
     * 单独insert appItem
     * @param appItemId
     * @param kvs
     * @return
     */
    int updateAppItemApi(Long appItemId, KeyValueDto kvs);


    List<KeyValueEntity> findAppItemNewExtraApi(Long appItemId,Long limitNum);

    List<KeyValueEntity> findAppItemAllApi(Long appItemId);

    int updateEntriesApi(Long appItemId,List<KeyValueDto> kv);

    List<KeyValueEntity> findAppItemEntriesByItemAndPropApi(List<Long> appItemIdList, String propName, String propValue);

    List<KeyValueDto> findItemAllApi(Long itemId);
}
