/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.tool.sku;

import cn.com.duiba.goods.center.api.remoteservice.dto.sku.SkuAttributeNode;
import cn.com.duiba.goods.center.api.remoteservice.tool.sku.SkuResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.javatuples.Pair;

public abstract class AbstractSkuResolver<T, R extends Serializable>
implements SkuResolver<T, R> {
    private static final String ATTRIBUTE_SEPARATOR = ":";
    private static final String ATTRIBUTE_GROUP_SEPARATOR = ";";
    private static final String NO_ATTRIBUTE_VALUE = "0:0";
    private static final Long DEFAULT_ATTRIBUTE_ID = 0L;
    private static final Long DEFAULT_ATTRIBUTE_VALUE_ID = 0L;

    @Override
    public List<T> resolveNodes(Long appItemId, Long itemId, List<SkuAttributeNode<R>> nodes) {
        return this.resolveNodes(appItemId, itemId, nodes, null);
    }

    @Override
    public List<T> resolveNodes(Long appItemId, Long itemId, List<SkuAttributeNode<R>> nodes, SkuResolver.ResolverListener<SkuAttributeNode<R>, T> listener) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Collections.emptyList();
        }
        ArrayList skuList = new ArrayList();
        for (SkuAttributeNode<R> node : nodes) {
            this.resolveNode(appItemId, itemId, skuList, "", node, listener);
        }
        return skuList;
    }

    @Override
    public List<T> resolveNode(Long appItemId, Long itemId, SkuAttributeNode<R> node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList skuList = new ArrayList();
        this.resolveNode(appItemId, itemId, skuList, "", node, null);
        return skuList;
    }

    private void resolveNode(Long appItemId, Long itemId, List<T> skuList, String attributeJson, SkuAttributeNode<R> node, SkuResolver.ResolverListener<SkuAttributeNode<R>, T> listener) {
        block4: {
            Long valueId;
            Long attrId;
            block3: {
                attrId = NumberUtils.toLong((String)node.getSpecId(), (long)DEFAULT_ATTRIBUTE_ID);
                valueId = NumberUtils.toLong((String)node.getId(), (long)DEFAULT_ATTRIBUTE_VALUE_ID);
                if (!CollectionUtils.isEmpty(node.getChildren())) break block3;
                R skuInfo = this.getSkuInfo(node);
                if (skuInfo == null) break block4;
                attributeJson = StringUtils.join((Object[])new Serializable[]{attributeJson, attrId, ATTRIBUTE_SEPARATOR, valueId});
                T dto = this.toDto(appItemId, itemId, attributeJson, skuInfo);
                skuList.add(dto);
                if (listener == null) break block4;
                listener.apply(node, dto);
                break block4;
            }
            attributeJson = StringUtils.join((Object[])new Serializable[]{attributeJson, attrId, ATTRIBUTE_SEPARATOR, valueId, ATTRIBUTE_GROUP_SEPARATOR});
            if (listener != null) {
                listener.apply(node, null);
            }
            for (SkuAttributeNode<R> child : node.getChildren()) {
                if (StringUtils.isBlank((CharSequence)child.getImgUrl())) {
                    child.setImgUrl(node.getImgUrl());
                }
                this.resolveNode(appItemId, itemId, skuList, attributeJson, child, listener);
            }
        }
    }

    protected R getSkuInfo(SkuAttributeNode<R> node) {
        return node.getSkuInfo();
    }

    protected abstract T toDto(Long var1, Long var2, String var3, R var4);

    @Override
    public List<SkuAttributeNode<R>> reverse(List<T> skuList) {
        return this.reverse(skuList, null);
    }

    @Override
    public List<SkuAttributeNode<R>> reverse(List<T> skuList, SkuResolver.ResolverListener<T, Pair<SkuAttributeNode<R>, String>> listener) {
        if (CollectionUtils.isEmpty(skuList)) {
            return Collections.emptyList();
        }
        ArrayList<SkuAttributeNode<R>> nodes = new ArrayList<SkuAttributeNode<R>>();
        for (T sku : skuList) {
            this.reverseSku(sku, nodes, listener);
        }
        return nodes;
    }

    protected abstract String getAttributeJson(T var1);

    protected abstract R toVo(T var1);

    private void reverseSku(T sku, List<SkuAttributeNode<R>> nodes, SkuResolver.ResolverListener<T, Pair<SkuAttributeNode<R>, String>> listener) {
        String attributeJson = this.getAttributeJson(sku);
        if (StringUtils.isBlank((CharSequence)attributeJson)) {
            attributeJson = NO_ATTRIBUTE_VALUE;
        }
        String[] groups = attributeJson.split(ATTRIBUTE_GROUP_SEPARATOR);
        SkuAttributeNode<R> prevNode = null;
        SkuAttributeNode<R> headNode = null;
        int last = groups.length - 1;
        for (int i = 0; i < groups.length; ++i) {
            boolean isLeaf;
            String[] attrs = groups[i].split(ATTRIBUTE_SEPARATOR);
            String attrId = attrs[0];
            String valueId = attrs[1];
            String customValue = null;
            if (attrs.length > 2) {
                customValue = attrs[2];
            }
            boolean bl = isLeaf = i >= last;
            if (prevNode == null) {
                headNode = prevNode = this.getOrCreateNode(attrId, valueId, customValue, sku, nodes, isLeaf, listener);
            } else {
                prevNode = this.getOrCreateNode(attrId, valueId, customValue, sku, prevNode.getChildren(), isLeaf, listener);
            }
            this.postNode(headNode, prevNode);
        }
    }

    protected void postNode(SkuAttributeNode<R> headNode, SkuAttributeNode<R> node) {
    }

    private SkuAttributeNode<R> getOrCreateNode(String attrId, String valueId, String customValue, T sku, List<SkuAttributeNode<R>> nodes, boolean isLeaf, SkuResolver.ResolverListener<T, Pair<SkuAttributeNode<R>, String>> listener) {
        SkuAttributeNode<R> node = this.getNode(valueId, nodes);
        if (node == null) {
            node = this.newNode(attrId, valueId, sku, isLeaf);
            nodes.add(node);
        }
        if (listener != null) {
            listener.apply(sku, Pair.with(node, (Object)customValue));
        }
        return node;
    }

    private SkuAttributeNode<R> getNode(String valueId, List<SkuAttributeNode<R>> nodes) {
        for (SkuAttributeNode<R> node : nodes) {
            if (!Objects.equals(valueId, node.getId())) continue;
            return node;
        }
        return null;
    }

    private SkuAttributeNode<R> newNode(String specId, String valueId, T sku, boolean isLeaf) {
        SkuAttributeNode<Object> node = new SkuAttributeNode<Object>();
        node.setId(valueId);
        node.setSpecId(specId);
        if (!isLeaf) {
            node.setChildren(new ArrayList());
        } else {
            R vo = this.toVo(sku);
            node.setSkuInfo(vo);
        }
        return node;
    }

    protected Long parseString2Long(String value) {
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(value.trim());
    }

    protected String parseLong2String(Long value) {
        return value == null ? null : value.toString();
    }
}

